/*
 *   Copyright (C) 2006
 *   Siraj Razick <siraj@kdemail.net>
 *   PhobosK <phobosk@mail.kbfx.net>
 *   see Also AUTHORS
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef KBFX_BUTTON_H
#define KBFX_BUTTON_H

#include <tqdragobject.h>
#include <tqimage.h>
#include <tqlabel.h>
#include <tqpainter.h>
#include <tqpixmap.h>
#include <tqtimer.h>

#include <dcopclient.h>
#include <dcopref.h>
#include <kdebug.h>
#include <kimageeffect.h>
#include <tdelocale.h>
#include <tdemessagebox.h>
#include <tdepopupmenu.h>
#include <krun.h>

#include <kbfxconfig.h>
#include <kbfxplasmapixmapprovider.h>


class TQPixmap;
class TQLabel;

class KbfxButton:public TQLabel
{
		TQ_OBJECT
  

	public:
		KbfxButton ( TQWidget * parent, const char * name = 0 );
		~KbfxButton();
		void kbfx_vista_button_setFx ( bool choice );
		virtual void paintEvent ( TQPaintEvent *pe );
		virtual void enterEvent ( TQEvent * e ) ;
		virtual void leaveEvent ( TQEvent * e );
		virtual void mousePressEvent ( TQMouseEvent * e );
		virtual void dropEvent ( TQDropEvent *e );
		virtual void dragEnterEvent ( TQDragEnterEvent *e );
		static bool m_sizeHeight;
		static int m_size;
		TQCString findPanel();
		void readjust( bool );

	public slots:
		void loadSkins();
		void toggle();
		void toggleKMenu();
		void fade();
		void reloadConfig();
		void openKmenuEdit();
		void selfDeleter();
		void openConfigDialog();

	signals:
		void pressed();
		void hideMenu();
		void leave ();
		void clicked ();
		void showToolTip ();

	protected:
		TQPixmap m_over_skin;
		TQPixmap m_pressed_skin;
		TQPixmap m_release_skin;
		TQPixmap m_normal_skin;
		TQPixmap m_current_skin;

// 		mng support ???
		TQPixmap * m_buffer;
		TQTimer * m_anime_timer;
		TQMovie * m_normal_anime;
		TQMovie * m_pressed_anime;
		TQMovie * m_hover_anime;
		TQMovie * m_current_anime;
		TQString m_normal_path;
		TQString m_over_path;
		TQString m_pressed_path;
		bool m_anime_on;
		bool m_kicker_auto_adjust;
		DCOPClient * m_dcopClient;

		/* state of the button */
		bool m_toggle;
		TQTimer * fade_timer;
		float m_opacity;
		TQPixmap m_fadePix;
		int m_fadeTime;
};

#endif
