/***************************************************************************
 *   Copyright (C) 2005 by Joe Ferris                                      *
 *   jferris@optimistictech.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef _KATAPULT_H_
#define _KATAPULT_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <ksystemtray.h>
#include <kglobalaccel.h>
#include <tdeactioncollection.h>
#include <dcopobject.h>

#include <tqstring.h>
#include <tqptrlist.h>
#include <tqevent.h>
#include <tqtimer.h>
#include <tqdict.h>

#include <match.h>

#include "katapultdisplay.h"
#include "katapultcatalog.h"
#include "katapultaction.h"
#include "katapultiface.h"

class KHelpMenu;
class KatapultSettings;

class Katapult : public KSystemTray, virtual public KatapultIface
{
	TQ_OBJECT
  
public:
	Katapult();
	~Katapult();
    
	void setQuery(TQString);
	TQString query() const;

public slots:
	void updateDisplay();
	void showLauncher();
	void hideLauncher();
	void completeQuery();
	void clearQuery();
	void showShortcutsDialog();
	void showGlobalShortcutsDialog();
	void showAboutDialog();
	void loadCatalogPlugins();
	void initDisplay();
	virtual void keyReleased(TQKeyEvent *);
	void execute();
	void updateSystray();
	void showContextMenu();
	
protected:
	virtual void mousePressEvent(TQMouseEvent *);
	
private:
	void initAccel(TQWidget *);
	
	bool executing;
	int allStatus;
	KatapultDisplay *display;
	TDEGlobalAccel *globalAccel;
	TDEActionCollection *actions;
	KatapultSettings *settings;
  KHelpMenu *helpmenu;
	Match bestMatch;
	const KatapultAction *action;
	TQString _query;
	TQDict<KatapultCatalog> catalogs;
	TQTimer *hideTimer;
	TQTimer *clearTimer;
};

#endif // _KATAPULT_H_
