/*
 * Copyright (C) 2004 Magnus Kulke <mkulke@magnusmachine>
 */

#include "kasablanca.h"
#include <tdeapplication.h>
#include <dcopclient.h>
#include <tdeaboutdata.h>
#include <tdecmdlineargs.h>
#include <tdelocale.h>

static const char description[] =
    I18N_NOOP("A TDE FTP Client");

static const char version[] = "0.4.0.2";

static TDECmdLineOptions options[] =
{
//    { "+[URL]", I18N_NOOP( "Document to open." ), 0 },
    TDECmdLineLastOption
};

int main(int argc, char **argv)
{
	 TDELocale::setMainCatalogue("kasablanca");	

    TDEAboutData about("kasablanca", I18N_NOOP("kasablanca"), version, description,
                     TDEAboutData::License_GPL, "(C) 2004 Magnus Kulke", 0, 0,
							"sikor_sxe@radicalapproach.de");
    about.addAuthor( "Magnus Kulke", 0, "sikor_sxe@radicalapproach.de" );
    about.addAuthor( "Big Biff", 0, "bigbiff@chunkyfilms.org" );
	 about.addCredit( "Stefan Bogner", 0, "bochi@online.ms" );
	 about.addCredit( "Christoph Thielecke", 0, "u15119@hs-harz.de" );
	about.addCredit( "Richard Stellingwerf", 0, "justremenic@hotmail.com" );
    TDECmdLineArgs::init(argc, argv, &about);
    TDECmdLineArgs::addCmdLineOptions(options);
    TDEApplication app;

    // register ourselves as a dcop client
    app.dcopClient()->registerAs(app.name(), false);

    // see if we are starting with session management
    if (app.isRestored())
    {
        RESTORE(Kasablanca);
    }
    else
    {
        // no session.. just start up normally
        TDECmdLineArgs *args = TDECmdLineArgs::parsedArgs();
        if (args->count() == 0)
        {
            Kasablanca *widget = new Kasablanca;
            widget->show();
        }
        else
        {
            int i = 0;
            for (; i < args->count(); i++)
            {
                Kasablanca *widget = new Kasablanca;
                widget->show();
// TODO: Load the ftp url passed on the command line.
//                widget->load(args->url(i));
            }
        }
        args->clear();
    }

    return app.exec();
}

