/*
Gwenview - A simple image viewer for TDE
Copyright 2005 Aurelien Gateau

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

*/
#ifndef TREEVIEW_H
#define TREEVIEW_H

// KDE
#include <tdefiletreeview.h>

class KURL;
class TQShowEvent;

namespace Gwenview {


class TreeView : public KFileTreeView {
TQ_OBJECT
  
public:
	TreeView(TQWidget* parent);
	~TreeView();

public slots:
	void setURL(const KURL&);
	void createBranch(const KURL&);

signals:
	void urlChanged(const KURL&);

protected:
	virtual void showEvent(TQShowEvent*);
	virtual void contentsDragMoveEvent(TQDragMoveEvent*);
	virtual void contentsDragLeaveEvent(TQDragLeaveEvent*);
	virtual void contentsDropEvent(TQDropEvent*);

protected slots:
	virtual void slotNewTreeViewItems(KFileTreeBranch*, const KFileTreeViewItemList&);

private:
	struct Private;
	Private* d;
	friend class Private;

private slots:
	// Do not name this slot "slotPopulateFinished", it will clash with
	// "KFileTreeView::slotPopulateFinished".
	void slotTreeViewPopulateFinished(KFileTreeViewItem*);

	void autoOpenDropTarget();
};


} // namespace
#endif
