// File autogenerated

#if !defined(NETWORKMANAGERSETTINGS_H_INCLUDED)
#define NETWORKMANAGERSETTINGS_H_INCLUDED

// TQt includes
#include <tqmap.h>
#include <tqobject.h>

// TQt D-Bus includes
#include <tqdbuserror.h>

// forward declarations
class TQString;
class TQT_DBusConnection;
class TQT_DBusDataList;
class TQT_DBusError;
class TQT_DBusMessage;
class TQT_DBusObjectPath;
class TQT_DBusProxy;
class TQT_DBusVariant;
template <typename K> class TQT_DBusDataMap;
template <typename T> class TQValueList;

namespace DBus
{

class SettingsInterface : public TQObject
{
    TQ_OBJECT
    
public:
    SettingsInterface(const TQString& service, const TQString& path, TQObject* parent = 0, const char* name = 0);

    virtual ~SettingsInterface();

    void setConnection(const TQT_DBusConnection& connection);

signals:
    void AsyncErrorResponseDetected(int asyncCallId, const TQT_DBusError error);

    void PropertiesChanged(const TQMap< TQString, TQT_DBusVariant >& properties);

    void NewConnection(const TQT_DBusObjectPath& connection);

    void AddConnectionAsyncReply(int asyncCallId, const TQT_DBusObjectPath& path);

    void SaveHostnameAsyncReply(int asyncCallId);


public:
    virtual bool ListConnections(TQValueList< TQT_DBusObjectPath >& connections, TQT_DBusError& error);

    virtual bool GetConnectionByUuid(const TQString& uuid, TQT_DBusObjectPath& connection, TQT_DBusError& error);

    virtual bool AddConnectionAsync(int& asyncCallId, const TQT_DBusDataMap< TQString >& connection, TQT_DBusError& error);

    virtual bool SaveHostnameAsync(int& asyncCallId, const TQString& hostname, TQT_DBusError& error);

public:
    virtual void setDBusProperty(const TQString& name, const TQT_DBusVariant& variant, TQT_DBusError& error);
    virtual TQT_DBusVariant getDBusProperty(const TQString& name, TQT_DBusError& error) const;

    virtual TQString getHostname(TQT_DBusError& error) const;

    virtual bool getCanModify(TQT_DBusError& error) const;

protected slots: // usually no need to reimplement
    virtual void slotHandleDBusSignal(const TQT_DBusMessage& message);

    virtual void slotHandleAsyncReply(int id, const TQT_DBusMessage& message);

protected:
    TQT_DBusProxy* m_baseProxy;

    TQMap<int, TQString> m_asyncCalls;

private: // Hiding copy constructor and assignment operator
    SettingsInterface(const SettingsInterface&);
    SettingsInterface& operator=(const SettingsInterface&);
}; // class SettingsInterface

}; // namespace DBus

#endif //NETWORKMANAGERSETTINGS_H_INCLUDED

// End of File

