// File autogenerated

// declaration include
#include "networkmanagerpppproxy.h"

// TQt includes
#include <tqmap.h>
#include <tqstring.h>

// TQt D-Bus includes
#include <tqdbusdata.h>
#include <tqdbusdatamap.h>
#include <tqdbuserror.h>
#include <tqdbusmessage.h>
#include <tqdbusproxy.h>
#include <tqdbusvariant.h>


namespace DBus
{

NetworkManagerPPPProxy::NetworkManagerPPPProxy(const TQString& service, const TQString& path, TQObject* parent, const char* name)
    : TQObject(parent, name),
      m_baseProxy(new TQT_DBusProxy())
{
    m_baseProxy->setInterface("org.freedesktop.NetworkManager.PPP");
    m_baseProxy->setPath(path);
    m_baseProxy->setService(service);

    TQObject::connect(m_baseProxy, TQ_SIGNAL(asyncReply(int, const TQT_DBusMessage&)),
                     this,        TQ_SLOT(slotHandleAsyncReply(int, const TQT_DBusMessage&)));
}

NetworkManagerPPPProxy::~NetworkManagerPPPProxy()
{
    delete m_baseProxy;
}

void NetworkManagerPPPProxy::setConnection(const TQT_DBusConnection& connection)
{
    m_baseProxy->setConnection(connection);
}

bool NetworkManagerPPPProxy::SetIp4Config(const TQMap< TQString, TQT_DBusVariant >& config, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;

    parameters << TQT_DBusData::fromStringKeyMap(TQT_DBusDataMap< TQString >(config));

    TQT_DBusMessage reply = m_baseProxy->sendWithReply("SetIp4Config", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;
    return true;
}

bool NetworkManagerPPPProxy::SetState(TQ_UINT32 state, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;

    parameters << TQT_DBusData::fromUInt32(state);

    TQT_DBusMessage reply = m_baseProxy->sendWithReply("SetState", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;
    return true;
}

bool NetworkManagerPPPProxy::NeedSecretsAsync(int& asyncCallId, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;


    asyncCallId = m_baseProxy->sendWithAsyncReply("NeedSecrets", parameters);

    if (asyncCallId != 0) m_asyncCalls[asyncCallId] = "NeedSecrets";

    error = TQT_DBusError();
    return (asyncCallId != 0);
}

void NetworkManagerPPPProxy::slotHandleAsyncReply(int asyncCallId, const TQT_DBusMessage& message)
{
    TQMap<int, TQString>::iterator findIt = m_asyncCalls.find(asyncCallId);
    if (findIt == m_asyncCalls.end()) return;

    const TQString signalName = findIt.data();
    m_asyncCalls.erase(findIt);

    if (signalName == "NeedSecrets")
    {
        int _asyncCallId = asyncCallId;

        if (message.type() == TQT_DBusMessage::ErrorMessage) {
            emit AsyncErrorResponseDetected(_asyncCallId, message.error());
        }

        TQString _username = message[0].toString();
        TQString _password = message[1].toString();

        emit NeedSecretsAsyncReply(_asyncCallId, _username, _password);
    }
}

}; // namespace DBus

#include "networkmanagerpppproxy.moc"

// End of File

