// File autogenerated

// declaration include
#include "activeconnectionproxy.h"

// TQt includes
#include <tqmap.h>
#include <tqstring.h>
#include <tqvaluelist.h>

// TQt D-Bus includes
#include <tqdbusconnection.h>
#include <tqdbusdata.h>
#include <tqdbusdatalist.h>
#include <tqdbusdatamap.h>
#include <tqdbuserror.h>
#include <tqdbusmessage.h>
#include <tqdbusobjectpath.h>
#include <tqdbusproxy.h>
#include <tqdbusvariant.h>


namespace DBus
{

ActiveConnectionProxy::ActiveConnectionProxy(const TQString& service, const TQString& path, TQObject* parent, const char* name)
    : TQObject(parent, name),
      m_baseProxy(new TQT_DBusProxy())
{
    m_baseProxy->setInterface("org.freedesktop.NetworkManager.Connection.Active");
    m_baseProxy->setPath(path);
    m_baseProxy->setService(service);

    TQObject::connect(m_baseProxy, TQ_SIGNAL(dbusSignal(const TQT_DBusMessage&)),
                     this,        TQ_SLOT(slotHandleDBusSignal(const TQT_DBusMessage&)));
}

ActiveConnectionProxy::~ActiveConnectionProxy()
{
    delete m_baseProxy;
}

void ActiveConnectionProxy::setConnection(const TQT_DBusConnection& connection)
{
    m_baseProxy->setConnection(connection);
}

void ActiveConnectionProxy::setDBusProperty(const TQString& name, const TQT_DBusVariant& value, TQT_DBusError& error)
{
    TQT_DBusConnection connection = m_baseProxy->connection();

    TQT_DBusMessage message = TQT_DBusMessage::methodCall(m_baseProxy->service(), m_baseProxy->path(), "org.freedesktop.DBus.Properties", "Set");

    message << TQT_DBusData::fromString(m_baseProxy->interface());
    message << TQT_DBusData::fromString(name);
    message << TQT_DBusData::fromVariant(value);

    connection.sendWithReply(message, &error);
}

TQT_DBusVariant ActiveConnectionProxy::getDBusProperty(const TQString& name, TQT_DBusError& error) const
{
    TQT_DBusConnection connection = m_baseProxy->connection();

    TQT_DBusMessage message = TQT_DBusMessage::methodCall(m_baseProxy->service(), m_baseProxy->path(), "org.freedesktop.DBus.Properties", "Get");

    message << TQT_DBusData::fromString(m_baseProxy->interface());
    message << TQT_DBusData::fromString(name);

    TQT_DBusMessage reply = connection.sendWithReply(message, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return TQT_DBusVariant();
    if (reply.count() != 1) return TQT_DBusVariant();

    bool ok = false;
    TQT_DBusVariant value = reply.front().toVariant(&ok);
    if (!ok) return TQT_DBusVariant();

    return value;
}

TQT_DBusObjectPath ActiveConnectionProxy::getConnection(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Connection", error);

    if (error.isValid()) return TQT_DBusObjectPath();

    bool ok = false;

    TQT_DBusObjectPath result =  variant.value.toObjectPath(&ok);
    if (!ok) {}

    return result;
}

TQT_DBusObjectPath ActiveConnectionProxy::getSpecificObject(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("SpecificObject", error);

    if (error.isValid()) return TQT_DBusObjectPath();

    bool ok = false;

    TQT_DBusObjectPath result =  variant.value.toObjectPath(&ok);
    if (!ok) {}

    return result;
}

TQString ActiveConnectionProxy::getUuid(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Uuid", error);

    if (error.isValid()) return TQString();

    bool ok = false;

    TQString result =  variant.value.toString(&ok);
    if (!ok) {}

    return result;
}

TQValueList< TQT_DBusObjectPath > ActiveConnectionProxy::getDevices(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Devices", error);

    if (error.isValid()) return TQValueList< TQT_DBusObjectPath >();

    bool ok = false;

    bool subOK = false;

    TQValueList< TQT_DBusObjectPath > result =  variant.value.toList(&ok).toObjectPathList(&subOK);
    if (!subOK) {}
    if (!ok) {}

    return result;
}

TQ_UINT32 ActiveConnectionProxy::getState(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("State", error);

    if (error.isValid()) return TQ_UINT32();

    bool ok = false;

    TQ_UINT32 result =  variant.value.toUInt32(&ok);
    if (!ok) {}

    return result;
}

bool ActiveConnectionProxy::getDefault(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Default", error);

    if (error.isValid()) return bool();

    bool ok = false;

    bool result =  variant.value.toBool(&ok);
    if (!ok) {}

    return result;
}

bool ActiveConnectionProxy::getDefault6(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Default6", error);

    if (error.isValid()) return bool();

    bool ok = false;

    bool result =  variant.value.toBool(&ok);
    if (!ok) {}

    return result;
}

bool ActiveConnectionProxy::getVpn(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Vpn", error);

    if (error.isValid()) return bool();

    bool ok = false;

    bool result =  variant.value.toBool(&ok);
    if (!ok) {}

    return result;
}

TQT_DBusObjectPath ActiveConnectionProxy::getMaster(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Master", error);

    if (error.isValid()) return TQT_DBusObjectPath();

    bool ok = false;

    TQT_DBusObjectPath result =  variant.value.toObjectPath(&ok);
    if (!ok) {}

    return result;
}

void ActiveConnectionProxy::slotHandleDBusSignal(const TQT_DBusMessage& message)
{
    if (message.member() == "PropertiesChanged")
    {
        TQMap< TQString, TQT_DBusVariant > _properties = message[0].toStringKeyMap().toVariantMap();

        emit PropertiesChanged(_properties);
    }
}

}; // namespace DBus

#include "activeconnectionproxy.moc"

// End of File

