// File autogenerated

// declaration include
#include "objectmanagerProxy.h"

// TQt includes
#include <tqstring.h>
#include <tqstringlist.h>

// TQt D-Bus includes
#include <tqdbusdata.h>
#include <tqdbusdatalist.h>
#include <tqdbusdatamap.h>
#include <tqdbuserror.h>
#include <tqdbusmessage.h>
#include <tqdbusobjectpath.h>
#include <tqdbusproxy.h>


namespace org
{
namespace freedesktop
{
namespace DBus
{

ObjectManagerProxy::ObjectManagerProxy(const TQString& service, const TQString& path, TQObject* parent, const char* name)
    : TQObject(parent, name),
      m_baseProxy(new TQT_DBusProxy())
{
    m_baseProxy->setInterface("org.freedesktop.DBus.ObjectManager");
    m_baseProxy->setPath(path);
    m_baseProxy->setService(service);

    TQObject::connect(m_baseProxy, TQ_SIGNAL(dbusSignal(const TQT_DBusMessage&)),
                     this,        TQ_SLOT(slotHandleDBusSignal(const TQT_DBusMessage&)));
}

ObjectManagerProxy::~ObjectManagerProxy()
{
    delete m_baseProxy;
}

void ObjectManagerProxy::setConnection(const TQT_DBusConnection& connection)
{
    m_baseProxy->setConnection(connection);
}

bool ObjectManagerProxy::GetManagedObjects(TQT_DBusDataMap< TQT_DBusObjectPath >& objects, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;


    TQT_DBusMessage reply = m_baseProxy->sendWithReply("GetManagedObjects", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;

    if (reply.count() != 1) return false;

    bool ok = false;

    objects = reply.front().toObjectPathKeyMap(&ok);
    if (!ok) return false;

    return true;
}

void ObjectManagerProxy::slotHandleDBusSignal(const TQT_DBusMessage& message)
{
    if (message.member() == "InterfacesAdded")
    {
        TQT_DBusObjectPath _object = message[0].toObjectPath();
        TQT_DBusDataMap< TQString > _interfaces = message[1].toStringKeyMap();

        emit InterfacesAdded(_object, _interfaces);
    }
    else if (message.member() == "InterfacesRemoved")
    {
        TQT_DBusObjectPath _object = message[0].toObjectPath();
        TQStringList _interfaces = message[1].toList().toTQStringList();

        emit InterfacesRemoved(_object, _interfaces);
    }
}

}; // namespace DBus

}; // namespace freedesktop

}; // namespace org

#include "objectmanagerProxy.moc"

// End of File

