#!/bin/sh
#
# %coypright%
#
# Please report bugs to: %maintainer%
#
# %license%
#
# Installer script for KMyFirewall %version%
# This is an automatic generated file DO NOT EDIT
#

readSetting() {
# echo "Reading config..."
    source ./install.config
}

INERACTIVE="1"

install() {
	ans="y"
	echo "Do you want to install this firewall configuration"
 	echo "to be started whenever you boot this computer? [Y/n]"
	
	if [ "$INERACTIVE" = "1" ]; then
		read newans
	fi
	
	if [ "$newans" = "n" ]; then
		ans=$newans
	fi

	if [ "$ans" = "y" ]; then
		/bin/sh data/kmfinstall.sh install ${SYSTEMTYPE} ${INITPATH} ${RCDEFAULTPATH} ${INITSCRIPT} data/kmyfirewall.sh
	else
		echo "Installation aborted!"
		echo
		exit 1
	fi
}

uninstall() {
	ans="y"
	echo "Do you really want to uninstall the KMyFirewall configuration"
	echo "form this computer? [Y/n]"
	
	if [ "$INERACTIVE" = "1" ]; then
		read newans
	fi
	
	if [ "$newans" = "n" ]; then
		ans=$newans
	fi

	if [ "$ans" = "y" ]; then
		/bin/sh data/kmfinstall.sh uninstall ${SYSTEMTYPE} ${INITPATH} ${RCDEFAULTPATH}
	else 
		echo "Uninstallation aborted!"
		echo
		exit 1
	
	fi
}

askRun() {
	ans="y"

    echo "Run the script? [Y/n]"
	if [ "$INERACTIVE" = "1" ]; then
		read newans
	fi

	if [ "$newans" = "n" ]; then
		ans=$newans
	fi
    
	if [ "$ans" = "y" ]; then
       run
    else
    	echo 
        echo "!!! YOUR SYSTEM STAYS UNPROTECTED !!!"
        echo 
		echo "You need to manualy start the firewall after intsllation"
        echo "to appy the configurtion you have installed."
        echo 
	echo "Run: '${INITPATH}/kmyfirewall start' to start the firewall"
    fi
}

run() {
	 ${INITPATH}/kmyfirewall start
}

askStop() {
    ans="n"
    echo "Flush all rules? [y/N]"
    if [ "$INERACTIVE" = "1" ]; then
		read ans
	else 
		ans="y"
	fi
	
    if [ "$ans" = "y" ]; then
        stop
    fi
}


stop() {
	if [ -e "${INITPATH}/kmyfirewall" ]; then
		${INITPATH}/kmyfirewall stop	
	elif [ -e "/tmp/kmyfirewall.d/data/kmyfirewall.sh" ]; then
		/bin/sh /tmp/kmyfirewall.d/data/kmyfirewall.sh -v stop	
	fi

	echo 
	echo "!!! YOU SYSTEM IS NOW UNPROTECTED !!!"
	echo 
}

printHello() {
    if [ "$INERACTIVE" = "1" ]; then
    	echo "KMyFirewall Package Installer v%version%"
    	echo "Please report bugs to: %maintainer%"
    	echo
    fi
}
printHelp() {
	echo "Usage: install.sh [-q] { --install | --uninstall | --reinstall | --help }"
	echo
	echo "Switches:"
	echo "	-q"
	echo "		No not require any user interaction"
	echo
	echo "Options:"
	echo "	install|--install|-i"
	echo "		Install the configuration."
	echo "		The installed firewall scrip will be automaticaly run at system boot."
	echo 
	echo "	uninstall|--uninstall|-u"
	echo "		Uninstall the configuration form the system."
	echo 
	echo "	reinstall|--reinstall|-r"
	echo "		Re-Installs the configuration e.g. the same as install.sh uninstall"
	echo "		followed by install.sh install"
	echo
	echo "	help|--help|-h"
	echo "		Print this help message"
	echo
}

#
# Execution starts here
#

readSetting


COMMAND=$1

if [ "$COMMAND" = "-q" ]; then
	COMMAND=$2
	INERACTIVE="0";
fi

printHello

case $COMMAND in
	install|--install|-i)
	install
	askRun
	;;

    uninstall|--uninstall|-u)
    askStop
    uninstall
    ;;
    
	reinstall|--reinstall|--r)
	askStop
	uninstall
	install
	askRun
	;;
	
	help|--help|-h)
	printHelp
	;;

	*)
    install
    askRun
    ;;
esac

