//
//
// C++ Interface: $MODULE$
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef KMFGENERICDOC_H
#define KMFGENERICDOC_H

#include "kmfdoc.h"
#include "kmfrulesetdoc.h"

// TQt includes
#include <tqdom.h>
#include <tqstring.h>
#include <tqstringlist.h>
#include <tqptrlist.h>


// KDE includes
#include <kurl.h>

// Project includes
#include "ipaddress.h"
#include "kmfprotocol.h"

namespace KMF {
class KMFError;
class KMFNetZone;
class KMFTarget;
class IPAddress;
class KMFCompilerInterface;
/**
@author Christian Hubinger
*/

class TDE_EXPORT KMFGenericDoc : public KMFDoc, public KMFRulesetDoc {
public:
	KMFGenericDoc( NetfilterObject*, const char*, KMFTarget* );
//	KMFGenericDoc( NetfiletObject*, const char* );

	~KMFGenericDoc();
	/** resets the document to the initial values
	*/
	void clear();

	bool isEmpty();
	
	/** return a TQString containing the documents script to 
		setup the firewall configuration */
	const TQString& compile();
	
	/** Return DomDocument of this Chain */
	const TQDomDocument& getDOMTree();

	virtual void loadXML( const TQDomDocument&, TQStringList& errors );
	virtual void loadXML( TQDomNode, TQStringList& errors );
	virtual int type();
	virtual void parseDocument( const KURL&, TQStringList& errors );
	
	/** Get the File dialog filter string for the document type */	
	virtual const TQString& getFileDialogFilter();
	
	KMFNetZone *incomingZone() const {
		return m_zone_incoming;
	};

	KMFNetZone *outgoingZone() const {
		return m_zone_outgoing;
	};

	KMFNetZone *trustedHostsZone() const {
		return m_zone_trusted;
	};

	KMFNetZone *maliciousHostsZone() const {
		return m_zone_malicious;
	};

	KMFNetZone *badServersHostsZone() const {
		return m_zone_badServers;
	};

	KMFNetZone *badClientsHostsZone() const {
		return m_zone_badClients;
	};
	TQPtrList<KMFNetZone>& zones() const;

	bool restrictOutgoingConnections() const {
		return m_restrictOutgoingConnections;
	};
	void setRestrictOutgoingConnections( bool ) ;

	bool allowIncomingConnections()const {
		return m_allowIncomingConnections;
	};
	void setAllowIncomingConnections( bool );

	bool allowPingReply() const {
		return m_allowPingReply;
	};
	void setAllowPingReply( bool );

	bool limitPingReply() const {
		return m_limitPingReply;
	};
	void setLimitPingReply( bool );

	bool useNat() const {
		return m_useNat;
	};
	
	void setUseNat( bool );

	bool useMasquerade() const {
		return m_useMasquerade;
	};
	void setUseMasquerade( bool );

	IPAddress* natAddress() const {
		return m_natAddress;
	};

	void setNatAddress( const TQString& );

	const TQString& outgoingInterface() const {
		return m_outgoingInterface;
	};
	void setOutgoingInterface( const TQString& );

	bool logDropped() const {
		return m_logDropped;
	};
	void setLogDropped( bool );

	bool limitLog() const {
		return m_limitLog;
	};
	void setLimitLog( bool );

	const TQString& logPrefix() const {
		return m_logPrefix;
	};
	void setLogPrefix( const TQString& );

protected:
	void initDoc();
	KMFNetZone* addZone( const TQString& name, KMFError* err );
	KMFError* delZone( KMFNetZone* zone );
	KMFNetZone* findZone( const TQString& name ) const;

private:
	// bool loadProtocolLibrary();
	
private: // DATA
	// TQPtrList<KMFProtocol> m_protocol_library;
	TQPtrList<KMFNetZone> m_zones;
	
	KMFNetZone* m_zone_incoming;
	KMFNetZone* m_zone_outgoing;
	KMFNetZone* m_zone_trusted;
	KMFNetZone* m_zone_malicious;
	KMFNetZone* m_zone_badClients;
	KMFNetZone* m_zone_badServers;
	bool m_allowPingReply, m_limitPingReply, m_allowIncomingConnections, m_restrictOutgoingConnections;

	bool m_useNat, m_useMasquerade, m_logDropped, m_limitLog;
	IPAddress *m_natAddress;
	TQString m_outgoingInterface, m_logPrefix;
	
};
}
#endif
