/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2005-11-18
 * Description : a class to apply ICC color correction to image.
 *
 * Copyright (C) 2005-2006 by F.J. Cruz <fj.cruz@supercable.es>
 * Copyright (C) 2005-2007 by Gilles Caulier <caulier dot gilles at gmail dot com> 
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef ICCTRANSFORM_H
#define ICCTRANSFORM_H

// TQt includes.

#include <tqstring.h>

// Local includes.

#include "dimg.h"
#include "digikam_export.h"

namespace Digikam
{

class IccTransformPriv;

class DIGIKAM_EXPORT IccTransform
{
public:

    IccTransform();
    ~IccTransform();

    bool apply(DImg& image);
    bool apply(DImg& image, TQByteArray& profile, int intent,
               bool useBPC=false, bool checkGamut=false, bool useBuiltin=false);

    void getTransformType(bool do_proof_profile);
    void getEmbeddedProfile(const DImg& image);
    int  getRenderingIntent();
    bool getUseBPC();

    bool hasInputProfile();
    bool hasOutputProfile();

    TQByteArray embeddedProfile() const;
    TQByteArray inputProfile() const;
    TQByteArray outputProfile() const;
    TQByteArray proofProfile() const;

    /** Input profile from file methods */
    void setProfiles(const TQString& input_profile, const TQString& output_profile);
    void setProfiles(const TQString& input_profile, const TQString& output_profile, const TQString& proof_profile);

    /** Embedded input profile methods */
    void setProfiles(const TQString& output_profile);
    void setProfiles(const TQString& output_profile, const TQString& proof_profile, bool forProof);

    /** Profile info methods */
    TQString getProfileDescription(const TQString& profile);

    TQString getEmbeddedProfileDescriptor();
    TQString getInputProfileDescriptor();
    TQString getOutpoutProfileDescriptor();
    TQString getProofProfileDescriptor();

private:

    TQByteArray loadICCProfilFile(const TQString& filePath);

private:

    IccTransformPriv* d;

};

}  // NameSpace Digikam

#endif   // ICCTRANSFORM_H
