%{CPP_TEMPLATE}

#include "%{APPNAMELC}.h"

#include <tqimage.h>
#include <tqpixmap.h>
#include <tqtoolbar.h>
#include <tqtoolbutton.h>
#include <tqpopupmenu.h>
#include <tqmenubar.h>
#include <tqtextedit.h>
#include <tqfile.h>
#include <tqfiledialog.h>
#include <statusbar.h>
#include <tqmessagebox.h>
#include <tqprinter.h>
#include <tqapplication.h>
#include <tqaccel.h>
#include <tqtextstream.h>
#include <tqpainter.h>
#include <tqpaintdevicemetrics.h>
#include <tqwhatsthis.h>

#include "filesave.xpm"
#include "fileopen.xpm"
#include "fileprint.xpm"

%{APPNAME}::%{APPNAME}()
    : TQMainWindow( 0, "%{APPNAME}", WDestructiveClose )
{
    printer = new TQPrinter;
    TQPixmap openIcon, saveIcon, printIcon;

    TQToolBar * fileTools = new TQToolBar( this, "file operations" );
    fileTools->setLabel( tr("File Operations") );

    openIcon = TQPixmap( fileopen );
    TQToolButton * fileOpen
	= new TQToolButton( openIcon, tr("Open File"), TQString(),
			   this, TQ_SLOT(choose()), fileTools, "open file" );

    saveIcon = TQPixmap( filesave );
    TQToolButton * fileSave
	= new TQToolButton( saveIcon, tr("Save File"), TQString(),
			   this, TQ_SLOT(save()), fileTools, "save file" );

    printIcon = TQPixmap( fileprint );
    TQToolButton * filePrint
	= new TQToolButton( printIcon, tr("Print File"), TQString(),
			   this, TQ_SLOT(print()), fileTools, "print file" );


    (void)TQWhatsThis::whatsThisButton( fileTools );

    TQString fileOpenText = tr("<p><img source=\"fileopen\"> "
	         "Click this button to open a <em>new file</em>. <br>"
                 "You can also select the <b>Open</b> command "
                 "from the <b>File</b> menu.</p>");

    TQWhatsThis::add( fileOpen, fileOpenText );

    TQMimeSourceFactory::defaultFactory()->setPixmap( "document-open", openIcon );

    TQString fileSaveText = tr("<p>Click this button to save the file you "
                 "are editing. You will be prompted for a file name.\n"
                 "You can also select the <b>Save</b> command "
                 "from the <b>File</b> menu.</p>");

    TQWhatsThis::add( fileSave, fileSaveText );

    TQString filePrintText = tr("Click this button to print the file you "
                 "are editing.\n You can also select the Print "
                 "command from the File menu.");

    TQWhatsThis::add( filePrint, filePrintText );


    TQPopupMenu * file = new TQPopupMenu( this );
    menuBar()->insertItem( tr("&File"), file );


    file->insertItem( tr("&New"), this, TQ_SLOT(newDoc()), CTRL+Key_N );

    int id;
    id = file->insertItem( openIcon, tr("&Open..."),
			   this, TQ_SLOT(choose()), CTRL+Key_O );
    file->setWhatsThis( id, fileOpenText );

    id = file->insertItem( saveIcon, tr("&Save"),
			   this, TQ_SLOT(save()), CTRL+Key_S );
    file->setWhatsThis( id, fileSaveText );

    id = file->insertItem( tr("Save &As..."), this, TQ_SLOT(saveAs()) );
    file->setWhatsThis( id, fileSaveText );

    file->insertSeparator();

    id = file->insertItem( printIcon, tr("&Print..."),
			   this, TQ_SLOT(print()), CTRL+Key_P );
    file->setWhatsThis( id, filePrintText );

    file->insertSeparator();

    file->insertItem( tr("&Close"), this, TQ_SLOT(close()), CTRL+Key_W );

    file->insertItem( tr("&Quit"), tqApp, TQ_SLOT( closeAllWindows() ), CTRL+Key_Q );

    menuBar()->insertSeparator();

    TQPopupMenu * help = new TQPopupMenu( this );
    menuBar()->insertItem( tr("&Help"), help );

    help->insertItem( tr("&About"), this, TQ_SLOT(about()), Key_F1 );
    help->insertItem( tr("About &TQt"), this, TQ_SLOT(aboutTQt()) );
    help->insertSeparator();
    help->insertItem( tr("What's &This"), this, TQ_SLOT(whatsThis()), SHIFT+Key_F1 );

    e = new TQTextEdit( this, "editor" );
    e->setFocus();
    setCentralWidget( e );
    statusBar()->message( tr("Ready"), 2000 );

    resize( 450, 600 );
}


%{APPNAME}::~%{APPNAME}()
{
    delete printer;
}



void %{APPNAME}::newDoc()
{
    %{APPNAME} *ed = new %{APPNAME};
    ed->setCaption(tr("TQt Example - Application"));
    ed->show();
}

void %{APPNAME}::choose()
{
    TQString fn = TQFileDialog::getOpenFileName( TQString(), TQString(),
					       this);
    if ( !fn.isEmpty() )
	load( fn );
    else
	statusBar()->message( tr("Loading aborted"), 2000 );
}


void %{APPNAME}::load( const TQString &fileName )
{
    TQFile f( fileName );
    if ( !f.open( IO_ReadOnly ) )
	return;

    TQTextStream ts( &f );
    e->setText( ts.read() );
    e->setModified( FALSE );
    setCaption( fileName );
    statusBar()->message( tr("Loaded document %1").arg(fileName), 2000 );
}


void %{APPNAME}::save()
{
    if ( filename.isEmpty() ) {
	saveAs();
	return;
    }

    TQString text = e->text();
    TQFile f( filename );
    if ( !f.open( IO_WriteOnly ) ) {
	statusBar()->message( tr("Could not write to %1").arg(filename),
			      2000 );
	return;
    }

    TQTextStream t( &f );
    t << text;
    f.close();

    e->setModified( FALSE );

    setCaption( filename );

    statusBar()->message( tr( "File %1 saved" ).arg( filename ), 2000 );
}


void %{APPNAME}::saveAs()
{
    TQString fn = TQFileDialog::getSaveFileName( TQString(), TQString(),
					       this );
    if ( !fn.isEmpty() ) {
	filename = fn;
	save();
    } else {
	statusBar()->message( tr("Saving aborted"), 2000 );
    }
}


void %{APPNAME}::print()
{
    // ###### Rewrite to use TQSimpleRichText to print here as well
    const int Margin = 10;
    int pageNo = 1;

    if ( printer->setup(this) ) {		// printer dialog
	statusBar()->message( tr("Printing...") );
	TQPainter p;
	if( !p.begin( printer ) )               // paint on printer
	    return;

	p.setFont( e->font() );
	int yPos	= 0;			// y-position for each line
	TQFontMetrics fm = p.fontMetrics();
	TQPaintDeviceMetrics metrics( printer ); // need width/height
						// of printer surface
	for( int i = 0 ; i < e->lines() ; i++ ) {
	    if ( Margin + yPos > metrics.height() - Margin ) {
		TQString msg( "Printing (page " );
		msg += TQString::number( ++pageNo );
		msg += ")...";
		statusBar()->message( msg );
		printer->newPage();		// no more room on this page
		yPos = 0;			// back to top of page
	    }
	    p.drawText( Margin, Margin + yPos,
			metrics.width(), fm.lineSpacing(),
			ExpandTabs | DontClip,
			e->text( i ) );
	    yPos = yPos + fm.lineSpacing();
	}
	p.end();				// send job to printer
	statusBar()->message( tr("Printing completed"), 2000 );
    } else {
	statusBar()->message( tr("Printing aborted"), 2000 );
    }
}

void %{APPNAME}::closeEvent( TQCloseEvent* ce )
{
    if ( !e->isModified() ) {
	ce->accept();
	return;
    }

    switch( TQMessageBox::information( this, tr("TQt Application Example"),
				      tr("Do you want to save the changes"
				      " to the document?"),
				      tr("Yes"), tr("No"), tr("Cancel"),
				      0, 1 ) ) {
    case 0:
	save();
	ce->accept();
	break;
    case 1:
	ce->accept();
	break;
    case 2:
    default: // just for sanity
	ce->ignore();
	break;
    }
}


void %{APPNAME}::about()
{
    TQMessageBox::about( this, tr("TQt Application Example"),
			tr("This example demonstrates simple use of "
			"TQMainWindow,\nTQMenuBar and TQToolBar."));
}


void %{APPNAME}::aboutTQt()
{
    TQMessageBox::aboutTQt( this, tr("TQt Application Example") );
}
