// File autogenerated

#if !defined(AGENT1PROXY_H_INCLUDED)
#define AGENT1PROXY_H_INCLUDED

// TQt includes
#include <tqmap.h>
#include <tqobject.h>

// TQt D-Bus includes
#include <tqdbuserror.h>

// forward declarations
class TQString;
class TQT_DBusConnection;
class TQT_DBusError;
class TQT_DBusMessage;
class TQT_DBusObjectPath;
class TQT_DBusProxy;

namespace org
{
namespace bluez
{

class Agent1Proxy : public TQObject
{
    TQ_OBJECT
    
public:
    Agent1Proxy(const TQString& service, const TQString& path, TQObject* parent = 0, const char* name = 0);

    virtual ~Agent1Proxy();

    void setConnection(const TQT_DBusConnection& connection);

signals:
    void AsyncErrorResponseDetected(int asyncCallId, const TQT_DBusError error);

    void RequestPinCodeAsyncReply(int asyncCallId, const TQString& pincode);

    void DisplayPinCodeAsyncReply(int asyncCallId);

    void RequestPasskeyAsyncReply(int asyncCallId, TQ_UINT32 passkey);

    void DisplayPasskeyAsyncReply(int asyncCallId);

    void RequestConfirmationAsyncReply(int asyncCallId);

    void RequestAuthorizationAsyncReply(int asyncCallId);

    void AuthorizeServiceAsyncReply(int asyncCallId);


public:
    virtual bool Release(TQT_DBusError& error);

    virtual bool Cancel(TQT_DBusError& error);

    virtual bool RequestPinCodeAsync(int& asyncCallId, const TQT_DBusObjectPath& device, TQT_DBusError& error);

    virtual bool DisplayPinCodeAsync(int& asyncCallId, const TQT_DBusObjectPath& device, const TQString& pincode, TQT_DBusError& error);

    virtual bool RequestPasskeyAsync(int& asyncCallId, const TQT_DBusObjectPath& device, TQT_DBusError& error);

    virtual bool DisplayPasskeyAsync(int& asyncCallId, const TQT_DBusObjectPath& device, TQ_UINT32 passkey, TQ_UINT16 entered, TQT_DBusError& error);

    virtual bool RequestConfirmationAsync(int& asyncCallId, const TQT_DBusObjectPath& device, TQ_UINT32 passkey, TQT_DBusError& error);

    virtual bool RequestAuthorizationAsync(int& asyncCallId, const TQT_DBusObjectPath& device, TQT_DBusError& error);

    virtual bool AuthorizeServiceAsync(int& asyncCallId, const TQT_DBusObjectPath& device, const TQString& uuid, TQT_DBusError& error);

protected slots: // usually no need to reimplement
    virtual void slotHandleAsyncReply(int id, const TQT_DBusMessage& message);

protected:
    TQT_DBusProxy* m_baseProxy;

    TQMap<int, TQString> m_asyncCalls;

private: // Hiding copy constructor and assignment operator
    Agent1Proxy(const Agent1Proxy&);
    Agent1Proxy& operator=(const Agent1Proxy&);
}; // class Agent1Proxy

}; // namespace bluez

}; // namespace org

#endif //AGENT1PROXY_H_INCLUDED

// End of File

