/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.storage.data;

import java.io.Serializable;
import net.ripe.rpki.validator3.storage.Binary;
import net.ripe.rpki.validator3.storage.IxMap;
import net.ripe.rpki.validator3.storage.Tx;
import net.ripe.rpki.validator3.storage.data.Key;
import net.ripe.rpki.validator3.storage.data.RefException;

@Binary
public class Ref<T extends Serializable>
implements Serializable {
    private final String mapName;
    private final Key key;

    private Ref(String mapName, Key key) {
        this.mapName = mapName;
        this.key = key;
    }

    public static <R extends Serializable> Ref<R> of(Tx.Read tx, IxMap<R> ix, Key sid) {
        if (ix.exists(tx, sid)) {
            return new Ref(ix.getName(), sid);
        }
        throw new RefException(ix, sid);
    }

    public static <R extends Serializable> Ref<R> unsafe(String name, Key sid) {
        return new Ref(name, sid);
    }

    public Key key() {
        return this.key;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Ref)) {
            return false;
        }
        Ref other = (Ref)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$mapName = this.getMapName();
        String other$mapName = other.getMapName();
        if (this$mapName == null ? other$mapName != null : !this$mapName.equals(other$mapName)) {
            return false;
        }
        Key this$key = this.key;
        Key other$key = other.key;
        return !(this$key == null ? other$key != null : !this$key.equals(other$key));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Ref;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $mapName = this.getMapName();
        result = result * 59 + ($mapName == null ? 43 : $mapName.hashCode());
        Key $key = this.key;
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        return result;
    }

    public String toString() {
        return "Ref(mapName=" + this.getMapName() + ", key=" + this.key + ")";
    }

    public String getMapName() {
        return this.mapName;
    }
}

