/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.storage.encoding;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.nio.charset.StandardCharsets;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpRange;
import net.ripe.rpki.validator3.storage.encoding.Coder;
import net.ripe.rpki.validator3.storage.encoding.GsonCoder;

/*
 * Exception performing whole class analysis ignored.
 */
public class GsonCoder<T>
implements Coder<T> {
    private final Gson gson = GsonCoder.getGson();
    private final Class<T> class_;

    public static Gson getGson() {
        return GsonCoder.getGson((boolean)false);
    }

    public static Gson getPrettyGson() {
        return GsonCoder.getGson((boolean)true);
    }

    public static Gson getGson(boolean pretty) {
        GsonBuilder gsonBuilder = new GsonBuilder().registerTypeAdapter(byte[].class, (Object)new ByteArraysGsonAdapter()).registerTypeAdapter(IpRange.class, (Object)new ParsingAdapter(IpRange::parse)).registerTypeAdapter(Asn.class, (Object)new ParsingAdapter(Asn::parse));
        if (pretty) {
            gsonBuilder.setPrettyPrinting();
        }
        return gsonBuilder.create();
    }

    public GsonCoder(Class<T> class_) {
        this.class_ = class_;
    }

    public byte[] toBytes(T t) {
        String json = this.gson.toJson(t);
        return json.getBytes(StandardCharsets.UTF_8);
    }

    public T fromBytes(byte[] bb) {
        String json = new String(bb, StandardCharsets.UTF_8);
        return (T)this.gson.fromJson(json, this.class_);
    }
}

