/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.storage.data;

import java.math.BigInteger;
import javax.validation.constraints.NotNull;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpRange;
import net.ripe.ipresource.IpResourceType;
import net.ripe.rpki.validator3.storage.Binary;
import net.ripe.rpki.validator3.storage.data.Base;

@Binary
public class RoaPrefix
extends Base<RoaPrefix> {
    public static final byte FAMILY_IPV4 = 4;
    public static final byte FAMILY_IPV6 = 6;
    @NotNull
    IpRange prefix;
    byte prefixFamily;
    Integer maximumLength;
    int effectiveLength;
    long asn;
    long notBefore;
    long notAfter;
    BigInteger serialNumber;

    public static RoaPrefix of(IpRange prefix, Integer maximumLength, Asn asn, long notBefore, long notAfter, BigInteger serialNumber) {
        RoaPrefix result = new RoaPrefix();
        result.setPrefix(prefix);
        result.setPrefixFamily(prefix.getType() == IpResourceType.IPv4 ? (byte)4 : 6);
        result.setMaximumLength(maximumLength);
        result.setEffectiveLength(maximumLength != null ? maximumLength.intValue() : prefix.getPrefixLength());
        result.setAsn(asn.longValue());
        result.setNotBefore(notBefore);
        result.setNotAfter(notAfter);
        result.setSerialNumber(serialNumber);
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RoaPrefix)) {
            return false;
        }
        RoaPrefix other = (RoaPrefix)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getPrefixFamily() != other.getPrefixFamily()) {
            return false;
        }
        if (this.getEffectiveLength() != other.getEffectiveLength()) {
            return false;
        }
        if (this.getAsn() != other.getAsn()) {
            return false;
        }
        if (this.getNotBefore() != other.getNotBefore()) {
            return false;
        }
        if (this.getNotAfter() != other.getNotAfter()) {
            return false;
        }
        Integer this$maximumLength = this.getMaximumLength();
        Integer other$maximumLength = other.getMaximumLength();
        if (this$maximumLength == null ? other$maximumLength != null : !((Object)this$maximumLength).equals(other$maximumLength)) {
            return false;
        }
        IpRange this$prefix = this.getPrefix();
        IpRange other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        BigInteger this$serialNumber = this.getSerialNumber();
        BigInteger other$serialNumber = other.getSerialNumber();
        return !(this$serialNumber == null ? other$serialNumber != null : !((Object)this$serialNumber).equals(other$serialNumber));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RoaPrefix;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getPrefixFamily();
        result = result * 59 + this.getEffectiveLength();
        long $asn = this.getAsn();
        result = result * 59 + (int)($asn >>> 32 ^ $asn);
        long $notBefore = this.getNotBefore();
        result = result * 59 + (int)($notBefore >>> 32 ^ $notBefore);
        long $notAfter = this.getNotAfter();
        result = result * 59 + (int)($notAfter >>> 32 ^ $notAfter);
        Integer $maximumLength = this.getMaximumLength();
        result = result * 59 + ($maximumLength == null ? 43 : ((Object)$maximumLength).hashCode());
        IpRange $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        BigInteger $serialNumber = this.getSerialNumber();
        result = result * 59 + ($serialNumber == null ? 43 : ((Object)$serialNumber).hashCode());
        return result;
    }

    public IpRange getPrefix() {
        return this.prefix;
    }

    public byte getPrefixFamily() {
        return this.prefixFamily;
    }

    public Integer getMaximumLength() {
        return this.maximumLength;
    }

    public int getEffectiveLength() {
        return this.effectiveLength;
    }

    public long getAsn() {
        return this.asn;
    }

    public long getNotBefore() {
        return this.notBefore;
    }

    public long getNotAfter() {
        return this.notAfter;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public void setPrefix(IpRange prefix) {
        this.prefix = prefix;
    }

    public void setPrefixFamily(byte prefixFamily) {
        this.prefixFamily = prefixFamily;
    }

    public void setMaximumLength(Integer maximumLength) {
        this.maximumLength = maximumLength;
    }

    public void setEffectiveLength(int effectiveLength) {
        this.effectiveLength = effectiveLength;
    }

    public void setAsn(long asn) {
        this.asn = asn;
    }

    public void setNotBefore(long notBefore) {
        this.notBefore = notBefore;
    }

    public void setNotAfter(long notAfter) {
        this.notAfter = notAfter;
    }

    public void setSerialNumber(BigInteger serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String toString() {
        return "RoaPrefix(prefix=" + this.getPrefix() + ", prefixFamily=" + this.getPrefixFamily() + ", maximumLength=" + this.getMaximumLength() + ", effectiveLength=" + this.getEffectiveLength() + ", asn=" + this.getAsn() + ", notBefore=" + this.getNotBefore() + ", notAfter=" + this.getNotAfter() + ", serialNumber=" + this.getSerialNumber() + ")";
    }
}

