/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.util;

import net.ripe.rpki.commons.rsync.Rsync;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class RsyncFactory {
    @Value(value="${rpki.validator.rsync.proxy.host:#{null}}")
    private String proxyHost;
    @Value(value="${rpki.validator.rsync.proxy.port:#{null}}")
    private Integer proxyPort;

    public Rsync rsyncDirectory(String location, String target) {
        Rsync rsync = new Rsync(location, target);
        rsync.addOptions(new String[]{"--update", "--times", "--copy-links", "--recursive", "--delete"});
        rsync.setProxy(this.proxy());
        return rsync;
    }

    public Rsync rsyncFile(String location, String target) {
        Rsync rsync = new Rsync(location, target);
        rsync.addOptions(new String[]{"--update", "--times", "--copy-links"});
        rsync.setProxy(this.proxy());
        return rsync;
    }

    private String proxy() {
        if (this.proxyHost != null) {
            if (this.proxyPort != null) {
                return this.proxyHost + ":" + this.proxyPort;
            }
            return this.proxyHost + ":873";
        }
        return null;
    }
}

