/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.storage.encoding.custom.validation;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.ripe.rpki.validator3.storage.data.Base;
import net.ripe.rpki.validator3.storage.data.validation.ValidationCheck;
import net.ripe.rpki.validator3.storage.encoding.Coder;
import net.ripe.rpki.validator3.storage.encoding.custom.BaseCoder;
import net.ripe.rpki.validator3.storage.encoding.custom.Coders;
import net.ripe.rpki.validator3.storage.encoding.custom.Encoded;
import net.ripe.rpki.validator3.storage.encoding.custom.Tags;

public class ValidationCheckCoder
implements Coder<ValidationCheck> {
    private static final short KEY_TAG = Tags.unique((int)111);
    private static final short STATUS_TAG = Tags.unique((int)112);
    private static final short LOCATION_TAG = Tags.unique((int)113);
    private static final short PARAMETERS_TAG = Tags.unique((int)114);

    public byte[] toBytes(ValidationCheck validationCheck) {
        Encoded encoded = new Encoded();
        BaseCoder.toBytes((Base)validationCheck, (Encoded)encoded);
        encoded.appendNotNull(KEY_TAG, (Object)validationCheck.getKey(), Coders::toBytes);
        encoded.appendNotNull(STATUS_TAG, (Object)validationCheck.getStatus(), s -> Coders.toBytes((String)s.name()));
        encoded.appendNotNull(LOCATION_TAG, (Object)validationCheck.getLocation(), Coders::toBytes);
        if (validationCheck.getParameters() != null && !validationCheck.getParameters().isEmpty()) {
            encoded.append(PARAMETERS_TAG, Coders.toBytes((Collection)validationCheck.getParameters(), Coders::toBytes));
        }
        return encoded.toByteArray();
    }

    public ValidationCheck fromBytes(byte[] bytes) {
        Map content = Encoded.fromByteArray((byte[])bytes).getContent();
        byte[] location = (byte[])content.get(LOCATION_TAG);
        byte[] key = (byte[])content.get(KEY_TAG);
        byte[] status = (byte[])content.get(STATUS_TAG);
        List<String> strings = Encoded.field((Map)content, (short)PARAMETERS_TAG).map(b -> Coders.fromBytes((byte[])b, Coders::toString)).orElse(Collections.emptyList());
        ValidationCheck validationCheck = new ValidationCheck(location == null ? null : Coders.toString((byte[])location), ValidationCheck.Status.valueOf((String)Coders.toString((byte[])status)), key == null ? null : Coders.toString((byte[])key), strings.toArray(new String[0]));
        BaseCoder.fromBytes((Map)content, (Base)validationCheck);
        return validationCheck;
    }
}

