/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.api.validationruns;

import io.swagger.annotations.Api;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.ripe.rpki.validator3.api.ApiResponse;
import net.ripe.rpki.validator3.api.PublicApiCall;
import net.ripe.rpki.validator3.api.validationruns.ValidationRunResource;
import net.ripe.rpki.validator3.storage.Storage;
import net.ripe.rpki.validator3.storage.data.validation.ValidationRun;
import net.ripe.rpki.validator3.storage.stores.TrustAnchors;
import net.ripe.rpki.validator3.storage.stores.ValidationRuns;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"Validation runs"})
@PublicApiCall
@RestController
@RequestMapping(path={"/api/validation-runs"}, produces={"application/vnd.net.ripe.rpki.validator.v3+json; charset=UTF-8"})
public class ValidationRunController {
    private static final Logger log = LoggerFactory.getLogger(ValidationRunController.class);
    @Autowired
    private ValidationRuns validationRuns;
    @Autowired
    private TrustAnchors trustAnchors;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private Storage storage;

    @GetMapping
    public ResponseEntity<ApiResponse<List<ValidationRunResource>>> list(Locale locale) {
        return (ResponseEntity)this.storage.readTx(tx -> ResponseEntity.ok((Object)ApiResponse.data((Links)new Links(new Link[]{ControllerLinkBuilder.linkTo((Object)((ValidationRunController)ControllerLinkBuilder.methodOn(ValidationRunController.class, (Object[])new Object[0])).list(locale)).withSelfRel()}), this.validationRuns.findAll(tx).stream().map(validationRun -> ValidationRunResource.of((ValidationRun)validationRun, vr -> this.validationRuns.getObjectCount(tx, vr), (MessageSource)this.messageSource, (Locale)locale)).collect(Collectors.toList()))));
    }

    @GetMapping(path={"/latest-successful"})
    public ResponseEntity<ApiResponse<List<ValidationRunResource>>> listLatestSuccessful(Locale locale) {
        return (ResponseEntity)this.storage.readTx(tx -> ResponseEntity.ok((Object)ApiResponse.data((Links)new Links(new Link[]{ControllerLinkBuilder.linkTo((Object)((ValidationRunController)ControllerLinkBuilder.methodOn(ValidationRunController.class, (Object[])new Object[0])).listLatestSuccessful(locale)).withSelfRel()}), this.validationRuns.findLatestSuccessful(tx, ValidationRun.class).stream().map(validationRun -> ValidationRunResource.of((ValidationRun)validationRun, vr -> this.validationRuns.getObjectCount(tx, vr), (MessageSource)this.messageSource, (Locale)locale)).collect(Collectors.toList()))));
    }

    @GetMapping(path={"/latest-completed-per-ta"})
    public ResponseEntity<ApiResponse<List<ValidationRunResource>>> listLatestCompletedPerTa(Locale locale) {
        return (ResponseEntity)this.storage.readTx(tx -> ResponseEntity.ok((Object)ApiResponse.data((Links)new Links(new Link[]{ControllerLinkBuilder.linkTo((Object)((ValidationRunController)ControllerLinkBuilder.methodOn(ValidationRunController.class, (Object[])new Object[0])).listLatestCompletedPerTa(locale)).withSelfRel()}), this.trustAnchors.findAll(tx).stream().flatMap(ta -> this.validationRuns.findLatestCompletedCaTreeValidationRun(tx, ta).map(validationRun -> Stream.of(ValidationRunResource.of((ValidationRun)validationRun, vr -> this.validationRuns.getObjectCount(tx, vr), (MessageSource)this.messageSource, (Locale)locale))).orElse(Stream.empty())).collect(Collectors.toList()))));
    }

    @GetMapping(path={"/{id}"})
    public ResponseEntity<ApiResponse<ValidationRunResource>> get(@PathVariable long id, Locale locale) {
        return (ResponseEntity)this.storage.readTx(tx -> this.validationRuns.get(tx, ValidationRun.class, id).map(validationRun -> ResponseEntity.ok((Object)ApiResponse.data((Object)ValidationRunResource.of((ValidationRun)validationRun, vr -> this.validationRuns.getObjectCount(tx, vr), (MessageSource)this.messageSource, (Locale)locale)))).orElse(ResponseEntity.notFound().build()));
    }
}

