/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.api.bgp;

import com.google.common.collect.ImmutableList;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpRange;
import net.ripe.ipresource.IpResource;
import net.ripe.ipresource.etree.IntervalMap;
import net.ripe.ipresource.etree.IntervalStrategy;
import net.ripe.ipresource.etree.IpResourceIntervalStrategy;
import net.ripe.ipresource.etree.NestedIntervalMap;
import net.ripe.rpki.validator3.api.Paging;
import net.ripe.rpki.validator3.api.SearchTerm;
import net.ripe.rpki.validator3.api.Sorting;
import net.ripe.rpki.validator3.api.bgp.BgpPreviewService;
import net.ripe.rpki.validator3.api.bgp.BgpRisDownloader;
import net.ripe.rpki.validator3.api.bgp.BgpRisDump;
import net.ripe.rpki.validator3.api.bgp.BgpRisEntry;
import net.ripe.rpki.validator3.api.ignorefilters.IgnoreFilter;
import net.ripe.rpki.validator3.api.ignorefilters.IgnoreFilterService;
import net.ripe.rpki.validator3.api.roaprefixassertions.RoaPrefixAssertionEntity;
import net.ripe.rpki.validator3.api.roaprefixassertions.RoaPrefixAssertionsService;
import net.ripe.rpki.validator3.domain.IgnoreFiltersPredicate;
import net.ripe.rpki.validator3.domain.RoaPrefixAssertion;
import net.ripe.rpki.validator3.domain.RoaPrefixDefinition;
import net.ripe.rpki.validator3.domain.ValidatedRoaPrefix;
import net.ripe.rpki.validator3.domain.validation.ValidatedRpkiObjects;
import net.ripe.rpki.validator3.util.Locks;
import net.ripe.rpki.validator3.util.Time;
import org.apache.commons.lang3.tuple.Pair;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class BgpPreviewService {
    private static final Logger log = LoggerFactory.getLogger(BgpPreviewService.class);
    private final int bgpRisVisibilityThreshold;
    private final BgpRisDownloader bgpRisDownloader;
    private final ReentrantLock downloadLock = new ReentrantLock();
    private final ReentrantReadWriteLock dataLock = new ReentrantReadWriteLock();
    private List<BgpRisDump> bgpRisDumps;
    private IntervalMap<IpRange, List<RoaPrefixDefinition>> roaPrefixes = new NestedIntervalMap((IntervalStrategy)IpResourceIntervalStrategy.getInstance());
    private IntervalMap<IpRange, List<RoaPrefixDefinition>> filteredRoaPrefixes = new NestedIntervalMap((IntervalStrategy)IpResourceIntervalStrategy.getInstance());
    private ImmutableList<ValidatedRoaPrefix> validatedRoaPrefixes = ImmutableList.of();
    private ImmutableList<RoaPrefixAssertion> roaPrefixAssertions = ImmutableList.of();
    private ImmutableList<IgnoreFilter> ignoreFilters = ImmutableList.of();
    private Map<String, ImmutableList<BgpPreviewEntry>> bgpPreviewEntries = new TreeMap();
    private static IpRange DEFAULT_IPV4_ROUTE = IpRange.parse((String)"0.0.0.0/0");
    private static IpRange DEFAULT_IPV6_ROUTE = IpRange.parse((String)"::/0");

    @Autowired
    public BgpPreviewService(@Value(value="${rpki.validator.bgp.ris.dump.urls}") String[] bgpRisDumpUrls, @Value(value="${rpki.validator.bgp.ris.visibility.threshold}") int bgpRisVisibilityThreshold, BgpRisDownloader bgpRisDownloader, ValidatedRpkiObjects validatedRpkiObjects, IgnoreFilterService ignoreFilterService, RoaPrefixAssertionsService roaPrefixAssertionsService) {
        this.bgpRisVisibilityThreshold = bgpRisVisibilityThreshold;
        this.bgpRisDownloader = bgpRisDownloader;
        this.bgpRisDumps = Arrays.stream(bgpRisDumpUrls).map(url -> BgpRisDump.of((String)url, null, Optional.empty())).collect(Collectors.toList());
        validatedRpkiObjects.addListener(objects -> this.updateValidatedRoaPrefixes(objects.stream().flatMap(x -> x.getRoaPrefixes().stream())));
        ignoreFilterService.addListener(arg_0 -> this.updateIgnoreFilters(arg_0));
        roaPrefixAssertionsService.addListener(arg_0 -> this.updateRoaPrefixAssertions(arg_0));
    }

    public void downloadRisPreview() {
        Locks.locked((Lock)this.downloadLock, () -> {
            log.info("Updating BGP RIS dumps");
            List updated = ((List)Locks.locked((Lock)this.dataLock.readLock(), () -> this.bgpRisDumps)).stream().map(dump -> this.bgpRisDownloader.fetch(dump, entry -> {
                if (entry.getVisibility() >= this.bgpRisVisibilityThreshold && BgpPreviewService.makesSenseToShowInPreview((BgpRisEntry)entry)) {
                    return Stream.of(BgpPreviewEntry.of((Asn)entry.getOrigin(), (IpRange)entry.getPrefix(), (Validity)Validity.UNKNOWN));
                }
                return Stream.empty();
            })).collect(Collectors.toList());
            this.updateBgpRisDump(updated);
            log.info("Finished updating BGP RIS dumps");
        });
    }

    public BgpPreviewResult find(SearchTerm searchTerm, Sorting sorting, Paging paging) {
        if (paging == null) {
            paging = Paging.of((Long)0L, (Long)Long.MAX_VALUE);
        }
        if (sorting == null) {
            sorting = Sorting.of((Sorting.By)Sorting.By.PREFIX, (Sorting.Direction)Sorting.Direction.ASC);
        }
        Sorting finalSorting = sorting;
        Paging finalPaging = paging;
        Predicate searchPredicate = BgpPreviewEntry.access$000((SearchTerm)searchTerm);
        return (BgpPreviewResult)Locks.locked((Lock)this.dataLock.readLock(), () -> {
            int count = searchTerm == null ? this.bgpPreviewEntries.values().stream().map(AbstractCollection::size).reduce(0, Integer::sum) : (int)this.bgpPreviewEntries.values().stream().flatMap(Collection::stream).filter(searchPredicate).count();
            Stream entries = this.bgpPreviewEntries.values().stream().flatMap(Collection::stream).filter(searchPredicate).sorted(BgpPreviewEntry.access$100((Sorting)finalSorting)).skip(finalPaging.getStartFrom()).limit(finalPaging.getPageSize());
            DateTime lastModified = this.bgpRisDumps.stream().map(BgpRisDump::getLastModified).filter(Objects::nonNull).max(Comparator.naturalOrder()).orElse(DateTime.now());
            return BgpPreviewResult.of((int)count, (long)lastModified.getMillis(), entries);
        });
    }

    public List<BgpPreviewEntry> findAffected(IpRange prefix, Integer maximumLength) {
        return (List)Locks.locked((Lock)this.dataLock.readLock(), () -> this.bgpPreviewEntries.values().parallelStream().flatMap(Collection::stream).filter(entry -> prefix.contains((IpResource)entry.getPrefix())).collect(Collectors.toList()));
    }

    public void updateBgpRisDump(Collection<BgpRisDump<BgpPreviewEntry>> updated) {
        Locks.locked((Lock)this.dataLock.writeLock(), () -> {
            HashMap updatedDumps = new HashMap(this.bgpPreviewEntries);
            for (BgpRisDump dump : updated) {
                dump.getEntries().ifPresent(entries -> updatedDumps.put(dump.getUrl(), entries));
            }
            this.bgpPreviewEntries = this.validateBgpRisEntries(updatedDumps, this.roaPrefixes);
            this.bgpRisDumps = updated.stream().map(x -> BgpRisDump.of((String)x.getUrl(), (DateTime)x.getLastModified(), Optional.empty())).collect(Collectors.toList());
        });
    }

    private static boolean makesSenseToShowInPreview(BgpRisEntry entry) {
        return !DEFAULT_IPV4_ROUTE.equals((Object)entry.getPrefix()) && !DEFAULT_IPV6_ROUTE.equals((Object)entry.getPrefix());
    }

    void updateValidatedRoaPrefixes(Stream<ValidatedRoaPrefix> prefixes) {
        Locks.locked((Lock)this.dataLock.writeLock(), () -> {
            this.validatedRoaPrefixes = ImmutableList.copyOf(prefixes.iterator());
            this.roaPrefixes = BgpPreviewService.recalculateRoaPrefixes((ImmutableList)this.validatedRoaPrefixes, (ImmutableList)this.ignoreFilters, (ImmutableList)this.roaPrefixAssertions);
            this.filteredRoaPrefixes = BgpPreviewService.recalculateFilteredRoaPrefixes((ImmutableList)this.validatedRoaPrefixes, (ImmutableList)this.ignoreFilters);
            this.bgpPreviewEntries = this.validateBgpRisEntries(this.bgpPreviewEntries, this.roaPrefixes);
        });
    }

    private void updateIgnoreFilters(Collection<IgnoreFilter> filters) {
        Locks.locked((Lock)this.dataLock.writeLock(), () -> {
            this.ignoreFilters = ImmutableList.copyOf((Collection)filters);
            this.roaPrefixes = BgpPreviewService.recalculateRoaPrefixes((ImmutableList)this.validatedRoaPrefixes, (ImmutableList)this.ignoreFilters, (ImmutableList)this.roaPrefixAssertions);
            this.filteredRoaPrefixes = BgpPreviewService.recalculateFilteredRoaPrefixes((ImmutableList)this.validatedRoaPrefixes, (ImmutableList)this.ignoreFilters);
            this.bgpPreviewEntries = this.validateBgpRisEntries(this.bgpPreviewEntries, this.roaPrefixes);
        });
    }

    private void updateRoaPrefixAssertions(Collection<RoaPrefixAssertionEntity> assertions) {
        Locks.locked((Lock)this.dataLock.writeLock(), () -> {
            this.roaPrefixAssertions = ImmutableList.copyOf(assertions.stream().map(p -> RoaPrefixAssertion.of((long)p.getAsn(), (IpRange)p.getPrefix(), (Integer)p.getMaxPrefixLength(), (Long)p.getId(), (String)p.getComment())).iterator());
            this.roaPrefixes = BgpPreviewService.recalculateRoaPrefixes((ImmutableList)this.validatedRoaPrefixes, (ImmutableList)this.ignoreFilters, (ImmutableList)this.roaPrefixAssertions);
            this.bgpPreviewEntries = this.validateBgpRisEntries(this.bgpPreviewEntries, this.roaPrefixes);
        });
    }

    private static NestedIntervalMap<IpRange, List<RoaPrefixDefinition>> recalculateRoaPrefixes(ImmutableList<ValidatedRoaPrefix> validatedRoaPrefixes, ImmutableList<IgnoreFilter> ignoreFilters, ImmutableList<RoaPrefixAssertion> roaPrefixAssertions) {
        NestedIntervalMap roaPrefixes = new NestedIntervalMap((IntervalStrategy)IpResourceIntervalStrategy.getInstance());
        Stream.concat(validatedRoaPrefixes.stream().filter(new IgnoreFiltersPredicate(ignoreFilters.stream()).negate()), roaPrefixAssertions.stream()).forEach(p -> {
            IpRange ipRange = p.getPrefix();
            ArrayList<RoaPrefixDefinition> existing = (ArrayList<RoaPrefixDefinition>)roaPrefixes.findExact((Object)ipRange);
            if (existing == null) {
                existing = new ArrayList<RoaPrefixDefinition>(1);
                roaPrefixes.put((Object)ipRange, existing);
            }
            existing.add((RoaPrefixDefinition)p);
        });
        return roaPrefixes;
    }

    private static NestedIntervalMap<IpRange, List<RoaPrefixDefinition>> recalculateFilteredRoaPrefixes(ImmutableList<ValidatedRoaPrefix> validatedRoaPrefixes, ImmutableList<IgnoreFilter> ignoreFilters) {
        NestedIntervalMap roaPrefixes = new NestedIntervalMap((IntervalStrategy)IpResourceIntervalStrategy.getInstance());
        validatedRoaPrefixes.stream().filter(new IgnoreFiltersPredicate(ignoreFilters.stream())).forEach(p -> {
            IpRange ipRange = p.getPrefix();
            ArrayList<ValidatedRoaPrefix> existing = (ArrayList<ValidatedRoaPrefix>)roaPrefixes.findExact((Object)ipRange);
            if (existing == null) {
                existing = new ArrayList<ValidatedRoaPrefix>(1);
                roaPrefixes.put((Object)ipRange, existing);
            }
            existing.add((ValidatedRoaPrefix)p);
        });
        return roaPrefixes;
    }

    private <T> Map<T, ImmutableList<BgpPreviewEntry>> validateBgpRisEntries(Map<T, ImmutableList<BgpPreviewEntry>> bgpRisEntries, IntervalMap<IpRange, List<RoaPrefixDefinition>> roaPrefixes) {
        return bgpRisEntries.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.validateBgpRisEntries((ImmutableList)entry.getValue(), roaPrefixes)));
    }

    private ImmutableList<BgpPreviewEntry> validateBgpRisEntries(ImmutableList<BgpPreviewEntry> bgpRisEntries, IntervalMap<IpRange, List<RoaPrefixDefinition>> roaPrefixes) {
        Pair timed = Time.timed(() -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            bgpRisEntries.parallelStream().map(bgpRisEntry -> bgpRisEntry.ofValidity(BgpPreviewService.validateBgpRisEntry((IntervalMap)roaPrefixes, (BgpPreviewEntry)bgpRisEntry))).forEachOrdered(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
            return builder.build();
        });
        log.debug("validateBgpRisEntries duration: {} ms ({} RIS entries, {} validated ROA prefixes, {} ignore filters, {} ROA prefix assertions)", new Object[]{timed.getRight(), bgpRisEntries.size(), this.validatedRoaPrefixes.size(), this.ignoreFilters.size(), this.roaPrefixAssertions.size()});
        return (ImmutableList)timed.getLeft();
    }

    private static Validity validateBgpRisEntry(IntervalMap<IpRange, List<RoaPrefixDefinition>> roaPrefixes, BgpPreviewEntry bgpRisEntry) {
        Validity validity = Validity.UNKNOWN;
        int bgpPrefixLength = bgpRisEntry.getPrefix().getPrefixLength();
        for (List rs : roaPrefixes.findExactAndAllLessSpecific((Object)bgpRisEntry.getPrefix())) {
            for (RoaPrefixDefinition r : rs) {
                if (r.getAsn() == Integer.toUnsignedLong(bgpRisEntry.origin)) {
                    if (r.getEffectiveLength() < bgpPrefixLength) {
                        validity = Validity.INVALID_LENGTH;
                        continue;
                    }
                    return Validity.VALID;
                }
                if (validity == Validity.INVALID_LENGTH) continue;
                validity = Validity.INVALID_ASN;
            }
        }
        return validity;
    }

    private static Validity validateMatchingBgpRisEntry(RoaPrefixDefinition matchingRoaPrefix, BgpPreviewEntry bgpRisEntry) {
        if (matchingRoaPrefix.getAsn() == Integer.toUnsignedLong(bgpRisEntry.origin)) {
            if (matchingRoaPrefix.getEffectiveLength() < bgpRisEntry.getPrefix().getPrefixLength()) {
                return Validity.INVALID_LENGTH;
            }
            return Validity.VALID;
        }
        return Validity.INVALID_ASN;
    }

    public BgpValidityWithFilteredResource validity(Asn origin, IpRange prefix) {
        Pair p = (Pair)Locks.locked((Lock)this.dataLock.readLock(), () -> Pair.of((Object)this.validity(origin, prefix, this.roaPrefixes), (Object)this.validity(origin, prefix, this.filteredRoaPrefixes)));
        BgpValidity roas = (BgpValidity)p.getLeft();
        BgpValidity filtered = (BgpValidity)p.getRight();
        List filteredRoasWithoutUnknown = filtered.getValidatingRoas().stream().filter(r -> !Validity.UNKNOWN.toString().equals(r.getValidity())).collect(Collectors.toList());
        return BgpValidityWithFilteredResource.of((String)origin.toString(), (String)prefix.toString(), (String)roas.getValidity(), (List)roas.getValidatingRoas(), filteredRoasWithoutUnknown);
    }

    private BgpValidity validity(Asn origin, IpRange prefix, IntervalMap<IpRange, List<RoaPrefixDefinition>> prefixes) {
        List matchingRoaPrefixes = prefixes.findExactAndAllLessSpecific((Object)prefix).stream().flatMap(Collection::stream).map(r -> {
            BgpPreviewEntry bgpPreviewEntry = BgpPreviewEntry.of((Asn)origin, (IpRange)prefix, (Validity)Validity.UNKNOWN);
            Validity validity = BgpPreviewService.validateMatchingBgpRisEntry((RoaPrefixDefinition)r, (BgpPreviewEntry)bgpPreviewEntry);
            return Pair.of((Object)r, (Object)validity);
        }).sorted(Comparator.comparingInt(p -> {
            switch (1.$SwitchMap$net$ripe$rpki$validator3$api$bgp$BgpPreviewService$Validity[((Validity)p.getRight()).ordinal()]) {
                case 1: {
                    return 0;
                }
                case 2: {
                    return 1;
                }
                case 3: {
                    return 2;
                }
            }
            return 10;
        })).collect(Collectors.toList());
        Validity validity = matchingRoaPrefixes.stream().findFirst().map(Pair::getRight).orElse(Validity.UNKNOWN);
        List validatingRoaStream = matchingRoaPrefixes.stream().flatMap(p -> {
            RoaPrefixDefinition r = (RoaPrefixDefinition)p.getLeft();
            if (r instanceof ValidatedRoaPrefix) {
                ValidatedRoaPrefix roaPrefix = (ValidatedRoaPrefix)r;
                return roaPrefix.getLocations().stream().map(loc -> ValidatingRoa.of((String)String.valueOf(roaPrefix.getAsn()), (String)roaPrefix.getPrefix().toString(), (String)((Validity)p.getRight()).toString(), (Integer)roaPrefix.getMaximumLength(), (String)(roaPrefix.getTrustAnchor() == null ? null : roaPrefix.getTrustAnchor().getName()), (String)loc, null, null));
            }
            if (r instanceof RoaPrefixAssertion) {
                RoaPrefixAssertion roaPrefix = (RoaPrefixAssertion)r;
                return Stream.of(ValidatingRoa.of((String)String.valueOf(roaPrefix.getAsn()), (String)roaPrefix.getPrefix().toString(), (String)((Validity)p.getRight()).toString(), (Integer)roaPrefix.getMaximumLength(), (String)"Whitelist", null, (Long)roaPrefix.getRoaPrefixAssertionId(), (String)roaPrefix.getComment()));
            }
            return Stream.empty();
        }).distinct().collect(Collectors.toList());
        return BgpValidity.of((String)origin.toString(), (String)prefix.toString(), (String)validity.toString(), validatingRoaStream);
    }

    public List<BgpRisDump> getBgpDumps() {
        return (List)Locks.locked((Lock)this.dataLock.readLock(), () -> this.bgpRisDumps);
    }
}

