/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.rtr;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.time.Instant;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Provider;
import net.ripe.rpki.rtr.RtrClientHandler;
import net.ripe.rpki.rtr.domain.RtrCache;
import net.ripe.rpki.rtr.domain.RtrClients;
import net.ripe.rpki.rtr.domain.SerialNumber;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class RtrServer {
    private static final Logger log = LoggerFactory.getLogger(RtrServer.class);
    public static final String DEFAULT_RTR_HOST = "localhost";
    public static final int DEFAULT_RTR_PORT = 9178;
    private String address;
    private int port;
    private final RtrCache rtrCache;
    private final RtrClients clients;
    private final Provider<RtrClientHandler> rtrClientHandlerProvider;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;

    @Autowired
    public RtrServer(@Value(value="${rtr.server.address}") String address, @Value(value="${rtr.server.port}") int port, RtrCache rtrCache, RtrClients clients, Provider<RtrClientHandler> rtrClientHandlerProvider) {
        this.setAddress(address);
        this.setPort(port);
        this.rtrCache = rtrCache;
        this.clients = clients;
        this.rtrClientHandlerProvider = rtrClientHandlerProvider;
    }

    private void setAddress(String address) {
        this.address = !StringUtils.isEmpty((CharSequence)address) ? address : DEFAULT_RTR_HOST;
    }

    private void setPort(int port) {
        this.port = port == -1 ? 9178 : port;
    }

    @PostConstruct
    public void run() {
        new Thread(() -> {
            try {
                this.runNetty();
            }
            catch (InterruptedException e) {
                log.error("Error running Netty server");
            }
        }).start();
    }

    @PreDestroy
    public void stop() {
        this.shutdownWorkers();
    }

    public void expireOldDeltas() {
        SerialNumber lowestSerialNumber = this.clients.getLowestSerialNumber().orElse(this.rtrCache.getSerialNumber());
        Set forgottenDeltas = this.rtrCache.forgetDeltasBefore(lowestSerialNumber);
        if (!forgottenDeltas.isEmpty()) {
            log.info("removed deltas for serial numbers {}", (Object)forgottenDeltas.stream().map(sn -> String.valueOf(sn.getValue())).sorted().collect(Collectors.joining(", ")));
        }
    }

    public void disconnectInactiveClients() {
        int disconnected = this.clients.disconnectInactive(Instant.now());
        if (disconnected > 0) {
            log.info("disconnected {} inactive clients", (Object)disconnected);
        }
    }

    private void runNetty() throws InterruptedException {
        this.bossGroup = new NioEventLoopGroup();
        this.workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new /* Unavailable Anonymous Inner Class!! */).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
            log.info("Running RTR at port {}", (Object)this.port);
            ChannelFuture f = b.bind(this.address, this.port).sync();
            f.channel().closeFuture().sync();
        }
        finally {
            this.shutdownWorkers();
        }
    }

    private void shutdownWorkers() {
        this.clients.clear();
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully();
        }
        if (this.bossGroup != null) {
            this.bossGroup.shutdownGracefully();
        }
    }

    static /* synthetic */ Provider access$000(RtrServer x0) {
        return x0.rtrClientHandlerProvider;
    }
}

