/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.storage.encoding.custom;

import java.util.Collection;
import java.util.Map;
import net.ripe.rpki.validator3.storage.data.Base;
import net.ripe.rpki.validator3.storage.data.TrustAnchor;
import net.ripe.rpki.validator3.storage.encoding.Coder;
import net.ripe.rpki.validator3.storage.encoding.custom.BaseCoder;
import net.ripe.rpki.validator3.storage.encoding.custom.Coders;
import net.ripe.rpki.validator3.storage.encoding.custom.Encoded;
import net.ripe.rpki.validator3.storage.encoding.custom.Tags;

public class TrustAnchorCoder
implements Coder<TrustAnchor> {
    private static final short NAME_TAG = Tags.unique((int)71);
    private static final short RSYNC_PREFETCH_TAG = Tags.unique((int)72);
    private static final short ENCODED_CERT_TAG = Tags.unique((int)73);
    private static final short LOCATIONS_TAG = Tags.unique((int)74);
    private static final short SPKI_SERIAL = Tags.unique((int)75);
    private static final short PRECONFIGURED_TAG = Tags.unique((int)76);
    private static final short INITIAL_VALIDATION_DONE_TAG = Tags.unique((int)77);

    public byte[] toBytes(TrustAnchor trustAnchor) {
        Encoded encoded = new Encoded();
        BaseCoder.toBytes((Base)trustAnchor, (Encoded)encoded);
        encoded.append(NAME_TAG, Coders.toBytes((String)trustAnchor.getName()));
        encoded.appendNotNull(ENCODED_CERT_TAG, (Object)trustAnchor.getEncodedCertificate(), c -> c);
        encoded.appendNotNull(SPKI_SERIAL, (Object)trustAnchor.getSubjectPublicKeyInfo(), Coders::toBytes);
        encoded.appendNotNull(RSYNC_PREFETCH_TAG, (Object)trustAnchor.getRsyncPrefetchUri(), Coders::toBytes);
        encoded.appendNotNull(PRECONFIGURED_TAG, (Object)trustAnchor.isPreconfigured(), Coders::toBytes);
        encoded.appendNotNull(INITIAL_VALIDATION_DONE_TAG, (Object)trustAnchor.isInitialCertificateTreeValidationRunCompleted(), Coders::toBytes);
        if (trustAnchor.getLocations() != null && !trustAnchor.getLocations().isEmpty()) {
            encoded.append(LOCATIONS_TAG, Coders.toBytes((Collection)trustAnchor.getLocations(), Coders::toBytes));
        }
        return encoded.toByteArray();
    }

    public TrustAnchor fromBytes(byte[] bytes) {
        Map content = Encoded.fromByteArray((byte[])bytes).getContent();
        TrustAnchor trustAnchor = new TrustAnchor();
        BaseCoder.fromBytes((Map)content, (Base)trustAnchor);
        trustAnchor.setName(Coders.toString((byte[])((byte[])content.get(NAME_TAG))));
        Encoded.field((Map)content, (short)ENCODED_CERT_TAG).ifPresent(arg_0 -> ((TrustAnchor)trustAnchor).setEncodedCertificate(arg_0));
        Encoded.field((Map)content, (short)SPKI_SERIAL).ifPresent(b -> trustAnchor.setSubjectPublicKeyInfo(Coders.toString((byte[])b)));
        Encoded.field((Map)content, (short)RSYNC_PREFETCH_TAG).ifPresent(b -> trustAnchor.setRsyncPrefetchUri(Coders.toString((byte[])b)));
        Encoded.field((Map)content, (short)PRECONFIGURED_TAG).ifPresent(b -> trustAnchor.setPreconfigured(Coders.toBoolean((byte[])b)));
        Encoded.field((Map)content, (short)INITIAL_VALIDATION_DONE_TAG).ifPresent(b -> trustAnchor.setInitialCertificateTreeValidationRunCompleted(Coders.toBoolean((byte[])b)));
        Encoded.field((Map)content, (short)LOCATIONS_TAG).ifPresent(b -> trustAnchor.setLocations(Coders.fromBytes((byte[])b, Coders::toString)));
        return trustAnchor;
    }
}

