/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.api;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class ApiLogger
extends HandlerInterceptorAdapter {
    private static final Logger logger = LoggerFactory.getLogger(ApiLogger.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        long startTime = System.currentTimeMillis();
        request.setAttribute("startTime", (Object)startTime);
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        super.afterCompletion(request, response, handler, ex);
        long startTime = (Long)request.getAttribute("startTime");
        long endTime = System.currentTimeMillis();
        long time = endTime - startTime;
        logger.debug("Handle :{}, time: {}ms", handler, (Object)time);
    }
}

