/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.api.trustanchors;

import com.google.common.io.PatternFilenameFilter;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.validation.Valid;
import net.ripe.rpki.validator3.api.trustanchors.AddTrustAnchor;
import net.ripe.rpki.validator3.background.ValidationScheduler;
import net.ripe.rpki.validator3.domain.validation.TrustAnchorState;
import net.ripe.rpki.validator3.domain.validation.ValidatedRpkiObjects;
import net.ripe.rpki.validator3.storage.Storage;
import net.ripe.rpki.validator3.storage.Tx;
import net.ripe.rpki.validator3.storage.data.Key;
import net.ripe.rpki.validator3.storage.data.TrustAnchor;
import net.ripe.rpki.validator3.storage.stores.RpkiRepositories;
import net.ripe.rpki.validator3.storage.stores.TrustAnchors;
import net.ripe.rpki.validator3.util.TrustAnchorLocator;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

@Component
@Validated
public class TrustAnchorService {
    private static final Logger log = LoggerFactory.getLogger(TrustAnchorService.class);
    private final TrustAnchors trustAnchors;
    private final RpkiRepositories rpkiRepositories;
    private final ValidatedRpkiObjects validatedRpkiObjects;
    private final ValidationScheduler validationScheduler;
    private final TrustAnchorState trustAnchorState;
    @Value(value="${rpki.validator.preconfigured.trust.anchors.directory}")
    private File preconfiguredTrustAnchorDirectory;
    private final Storage storage;

    @Autowired
    public TrustAnchorService(TrustAnchors trustAnchors, RpkiRepositories rpkiRepositories, ValidatedRpkiObjects validatedRpkiObjects, ValidationScheduler validationScheduler, TrustAnchorState trustAnchorState, Storage storage) {
        this.trustAnchors = trustAnchors;
        this.rpkiRepositories = rpkiRepositories;
        this.validatedRpkiObjects = validatedRpkiObjects;
        this.validationScheduler = validationScheduler;
        this.trustAnchorState = trustAnchorState;
        this.storage = storage;
    }

    public long execute(@Valid AddTrustAnchor command) {
        TrustAnchor trustAnchor = new TrustAnchor(false);
        trustAnchor.setName(command.getName());
        trustAnchor.setLocations(new ArrayList(command.getLocations()));
        trustAnchor.setSubjectPublicKeyInfo(command.getSubjectPublicKeyInfo());
        trustAnchor.setRsyncPrefetchUri(command.getRsyncPrefetchUri());
        return (Long)this.storage.writeTx(tx -> this.add(tx, trustAnchor));
    }

    long add(Tx.Write tx, TrustAnchor trustAnchor) {
        this.trustAnchors.add(tx, trustAnchor);
        tx.afterCommit(() -> this.validationScheduler.addTrustAnchor(trustAnchor));
        log.info("Added trust anchor '{}'", (Object)trustAnchor);
        return trustAnchor.key().asLong();
    }

    public void remove(long trustAnchorId) {
        this.storage.writeTx0(tx -> this.trustAnchors.get((Tx.Read)tx, Key.of((long)trustAnchorId)).ifPresent(trustAnchor -> {
            this.rpkiRepositories.removeAllForTrustAnchor(tx, trustAnchor);
            this.trustAnchors.remove(tx, trustAnchor);
            this.validatedRpkiObjects.remove(trustAnchor);
        }));
    }

    @PostConstruct
    public void managePreconfiguredAndExistingTrustAnchors() {
        log.info("Automatically adding preconfigured trust anchors");
        Object[] tals = this.preconfiguredTrustAnchorDirectory.listFiles((FilenameFilter)new PatternFilenameFilter(Pattern.compile("^.*\\.tal$")));
        if (ArrayUtils.isEmpty((Object[])tals)) {
            log.warn("No preconfigured trust anchors found at {}, skipping", (Object)this.preconfiguredTrustAnchorDirectory);
            return;
        }
        for (Object tal : tals) {
            TrustAnchorLocator locator = TrustAnchorLocator.fromFile((File)tal);
            this.storage.writeTx0(tx -> {
                Optional ta = this.trustAnchors.findBySubjectPublicKeyInfo((Tx.Read)tx, locator.getPublicKeyInfo());
                if (ta.isPresent()) {
                    log.info("Preconfigured trust anchor '{}' already installed, skipping", (Object)locator.getCaName());
                } else {
                    TrustAnchor trustAnchor = new TrustAnchor(true);
                    trustAnchor.setName(locator.getCaName());
                    trustAnchor.setLocations(locator.getCertificateLocations().stream().map(URI::toASCIIString).collect(Collectors.toList()));
                    trustAnchor.setSubjectPublicKeyInfo(locator.getPublicKeyInfo());
                    trustAnchor.setRsyncPrefetchUri((String)locator.getPrefetchUris().stream().filter(uri -> "rsync".equalsIgnoreCase(uri.getScheme())).map(URI::toASCIIString).findFirst().orElse(null));
                    this.add(tx, trustAnchor);
                }
            });
        }
        this.storage.readTx0(tx -> {
            log.info("Schedule validation for TAs that were in the database already");
            this.trustAnchors.findAll(tx).forEach(ta -> {
                this.trustAnchorState.setUnknown(ta);
                if (!this.validationScheduler.scheduledTrustAnchor(ta)) {
                    log.info("Adding {} to the validation scheduler", (Object)ta.getName());
                    this.validationScheduler.addTrustAnchor(ta);
                }
            });
        });
    }
}

