/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.domain.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import java.util.concurrent.ConcurrentHashMap;
import net.ripe.rpki.validator3.domain.metrics.TrustAnchorMetricsService;
import net.ripe.rpki.validator3.storage.Storage;
import net.ripe.rpki.validator3.storage.data.TrustAnchor;
import net.ripe.rpki.validator3.storage.data.validation.CertificateTreeValidationRun;
import net.ripe.rpki.validator3.storage.stores.ValidationRuns;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TrustAnchorMetricsService {
    private static final Logger log = LoggerFactory.getLogger(TrustAnchorMetricsService.class);
    @Autowired
    private MeterRegistry registry;
    @Autowired
    private Storage storage;
    @Autowired
    private ValidationRuns validationRuns;
    private ConcurrentHashMap<String, CertificateTreeValidationMetrics> certificateTreeValidationMetrics = new ConcurrentHashMap();

    public void update(TrustAnchor ta, CertificateTreeValidationRun vr, long durationMs) {
        String uri;
        String string = uri = ta.getLocations().size() > 0 ? (String)ta.getLocations().get(0) : null;
        if (uri == null) {
            log.error("Trust anchor {} does not have a location.", (Object)ta.getSubjectPublicKeyInfo());
            return;
        }
        this.certificateTreeValidationMetrics.computeIfAbsent(uri, key -> new CertificateTreeValidationMetrics(this, ta)).update(vr, durationMs);
    }

    public void setRegistry(MeterRegistry registry) {
        this.registry = registry;
    }

    public void setStorage(Storage storage) {
        this.storage = storage;
    }

    public void setValidationRuns(ValidationRuns validationRuns) {
        this.validationRuns = validationRuns;
    }

    public void setCertificateTreeValidationMetrics(ConcurrentHashMap<String, CertificateTreeValidationMetrics> certificateTreeValidationMetrics) {
        this.certificateTreeValidationMetrics = certificateTreeValidationMetrics;
    }

    static /* synthetic */ MeterRegistry access$000(TrustAnchorMetricsService x0) {
        return x0.registry;
    }

    static /* synthetic */ Storage access$100(TrustAnchorMetricsService x0) {
        return x0.storage;
    }

    static /* synthetic */ ValidationRuns access$200(TrustAnchorMetricsService x0) {
        return x0.validationRuns;
    }
}

