/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.api.trustanchors;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.ripe.rpki.validator3.api.trustanchors.TrustAnchorController;
import net.ripe.rpki.validator3.storage.data.TrustAnchor;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
@ApiModel(value="TrustAnchor")
public final class TrustAnchorResource {
    @ApiModelProperty(allowableValues="trust-anchor", required=true, position=1)
    private final String type;
    @ApiModelProperty(required=true, allowableValues="range[1,infinity]", example="1", position=2)
    private final long id;
    @ApiModelProperty(required=true, example="RPKI CA", position=3)
    private final String name;
    @ApiModelProperty(required=true, position=4)
    private final List<String> locations;
    @ApiModelProperty(required=true, position=5)
    private final String subjectPublicKeyInfo;
    @ApiModelProperty(position=6)
    private final String rsyncPrefetchUri;
    @ApiModelProperty(required=true, position=7)
    private final boolean preconfigured;
    @ApiModelProperty(required=true, position=8)
    private final boolean initialCertificateTreeValidationRunCompleted;
    @ApiModelProperty(position=9)
    private final byte[] certificate;
    @ApiModelProperty(required=true, position=10)
    private final Links links;

    public static TrustAnchorResource of(TrustAnchor trustAnchor, Locale locale) {
        return TrustAnchorResource.of((String)"trust-anchor", (long)trustAnchor.key().asLong(), (String)trustAnchor.getName(), (List)trustAnchor.getLocations(), (String)trustAnchor.getSubjectPublicKeyInfo(), (String)trustAnchor.getRsyncPrefetchUri(), (boolean)trustAnchor.isPreconfigured(), (boolean)trustAnchor.isInitialCertificateTreeValidationRunCompleted(), (byte[])trustAnchor.getEncodedCertificate(), (Links)new Links(new Link[]{ControllerLinkBuilder.linkTo((Object)((TrustAnchorController)ControllerLinkBuilder.methodOn(TrustAnchorController.class, (Object[])new Object[0])).get(trustAnchor.key().asLong(), locale)).withSelfRel()}));
    }

    @ConstructorProperties(value={"type", "id", "name", "locations", "subjectPublicKeyInfo", "rsyncPrefetchUri", "preconfigured", "initialCertificateTreeValidationRunCompleted", "certificate", "links"})
    private TrustAnchorResource(String type, long id, String name, List<String> locations, String subjectPublicKeyInfo, String rsyncPrefetchUri, boolean preconfigured, boolean initialCertificateTreeValidationRunCompleted, byte[] certificate, Links links) {
        this.type = type;
        this.id = id;
        this.name = name;
        this.locations = locations;
        this.subjectPublicKeyInfo = subjectPublicKeyInfo;
        this.rsyncPrefetchUri = rsyncPrefetchUri;
        this.preconfigured = preconfigured;
        this.initialCertificateTreeValidationRunCompleted = initialCertificateTreeValidationRunCompleted;
        this.certificate = certificate;
        this.links = links;
    }

    public static TrustAnchorResource of(String type, long id, String name, List<String> locations, String subjectPublicKeyInfo, String rsyncPrefetchUri, boolean preconfigured, boolean initialCertificateTreeValidationRunCompleted, byte[] certificate, Links links) {
        return new TrustAnchorResource(type, id, name, locations, subjectPublicKeyInfo, rsyncPrefetchUri, preconfigured, initialCertificateTreeValidationRunCompleted, certificate, links);
    }

    public String getType() {
        return this.type;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getLocations() {
        return this.locations;
    }

    public String getSubjectPublicKeyInfo() {
        return this.subjectPublicKeyInfo;
    }

    public String getRsyncPrefetchUri() {
        return this.rsyncPrefetchUri;
    }

    public boolean isPreconfigured() {
        return this.preconfigured;
    }

    public boolean isInitialCertificateTreeValidationRunCompleted() {
        return this.initialCertificateTreeValidationRunCompleted;
    }

    public byte[] getCertificate() {
        return this.certificate;
    }

    public Links getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TrustAnchorResource)) {
            return false;
        }
        TrustAnchorResource other = (TrustAnchorResource)o;
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List this$locations = this.getLocations();
        List other$locations = other.getLocations();
        if (this$locations == null ? other$locations != null : !((Object)this$locations).equals(other$locations)) {
            return false;
        }
        String this$subjectPublicKeyInfo = this.getSubjectPublicKeyInfo();
        String other$subjectPublicKeyInfo = other.getSubjectPublicKeyInfo();
        if (this$subjectPublicKeyInfo == null ? other$subjectPublicKeyInfo != null : !this$subjectPublicKeyInfo.equals(other$subjectPublicKeyInfo)) {
            return false;
        }
        String this$rsyncPrefetchUri = this.getRsyncPrefetchUri();
        String other$rsyncPrefetchUri = other.getRsyncPrefetchUri();
        if (this$rsyncPrefetchUri == null ? other$rsyncPrefetchUri != null : !this$rsyncPrefetchUri.equals(other$rsyncPrefetchUri)) {
            return false;
        }
        if (this.isPreconfigured() != other.isPreconfigured()) {
            return false;
        }
        if (this.isInitialCertificateTreeValidationRunCompleted() != other.isInitialCertificateTreeValidationRunCompleted()) {
            return false;
        }
        if (!Arrays.equals(this.getCertificate(), other.getCertificate())) {
            return false;
        }
        Links this$links = this.getLinks();
        Links other$links = other.getLinks();
        return !(this$links == null ? other$links != null : !this$links.equals(other$links));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List $locations = this.getLocations();
        result = result * 59 + ($locations == null ? 43 : ((Object)$locations).hashCode());
        String $subjectPublicKeyInfo = this.getSubjectPublicKeyInfo();
        result = result * 59 + ($subjectPublicKeyInfo == null ? 43 : $subjectPublicKeyInfo.hashCode());
        String $rsyncPrefetchUri = this.getRsyncPrefetchUri();
        result = result * 59 + ($rsyncPrefetchUri == null ? 43 : $rsyncPrefetchUri.hashCode());
        result = result * 59 + (this.isPreconfigured() ? 79 : 97);
        result = result * 59 + (this.isInitialCertificateTreeValidationRunCompleted() ? 79 : 97);
        result = result * 59 + Arrays.hashCode(this.getCertificate());
        Links $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : $links.hashCode());
        return result;
    }

    public String toString() {
        return "TrustAnchorResource(type=" + this.getType() + ", id=" + this.getId() + ", name=" + this.getName() + ", locations=" + this.getLocations() + ", subjectPublicKeyInfo=" + this.getSubjectPublicKeyInfo() + ", rsyncPrefetchUri=" + this.getRsyncPrefetchUri() + ", preconfigured=" + this.isPreconfigured() + ", initialCertificateTreeValidationRunCompleted=" + this.isInitialCertificateTreeValidationRunCompleted() + ", certificate=" + Arrays.toString(this.getCertificate()) + ", links=" + this.getLinks() + ")";
    }
}

