/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.rrdp;

import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Iterator;
import java.util.Locale;
import java.util.function.Consumer;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.ripe.rpki.validator3.rrdp.DeltaElement;
import net.ripe.rpki.validator3.rrdp.DeltaInfo;
import net.ripe.rpki.validator3.rrdp.DeltaPublish;
import net.ripe.rpki.validator3.rrdp.DeltaWithdraw;
import net.ripe.rpki.validator3.rrdp.Notification;
import net.ripe.rpki.validator3.rrdp.RrdpException;
import net.ripe.rpki.validator3.rrdp.RrdpParser;
import net.ripe.rpki.validator3.rrdp.SnapshotObject;
import net.ripe.rpki.validator3.util.Hex;

public class RrdpParser {
    public void parseSnapshot(InputStream inputStream, Consumer<SnapshotHeader> processSnapshotHeader, Consumer<SnapshotObject> processSnapshotObject) {
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLEventReader eventReader = factory.createXMLEventReader(inputStream);
            String sessionId = null;
            BigInteger serial = null;
            String uri = null;
            StringBuilder base64 = new StringBuilder();
            boolean inPublishElement = false;
            boolean snapshotHeaderProcessed = false;
            Base64.Decoder decoder = Base64.getDecoder();
            while (eventReader.hasNext()) {
                XMLEvent event = eventReader.nextEvent();
                block1 : switch (event.getEventType()) {
                    case 1: {
                        String qName;
                        StartElement startElement = event.asStartElement();
                        switch (qName = startElement.getName().getLocalPart().toLowerCase(Locale.ROOT)) {
                            case "publish": {
                                if (!snapshotHeaderProcessed) {
                                    throw new RrdpException("rrdp.parse.error", "snapshot header not present before published objects");
                                }
                                uri = this.getAttr(startElement, "uri", "Uri is not present in 'publish' element");
                                inPublishElement = true;
                                break block1;
                            }
                            case "snapshot": {
                                serial = new BigInteger(this.getAttr(startElement, "serial", "Notification serial is not present"));
                                sessionId = this.getAttr(startElement, "session_id", "Session id is not present");
                                processSnapshotHeader.accept(new SnapshotHeader(sessionId, serial));
                                snapshotHeaderProcessed = true;
                            }
                        }
                        break;
                    }
                    case 4: {
                        Characters characters = event.asCharacters();
                        if (!inPublishElement) break;
                        String thisBase64 = characters.getData();
                        base64.append(thisBase64.replaceAll("\\s", ""));
                        break;
                    }
                    case 2: {
                        EndElement endElement = event.asEndElement();
                        String qqName = endElement.getName().getLocalPart().toLowerCase(Locale.ROOT);
                        if (!"publish".equals(qqName)) break;
                        byte[] decoded = decoder.decode(base64.toString());
                        processSnapshotObject.accept(new SnapshotObject(decoded, uri));
                        inPublishElement = false;
                        base64 = new StringBuilder();
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            throw new RrdpException("Couldn't parse snapshot: ", (Throwable)e);
        }
    }

    public void parseDelta(InputStream inputStream, Consumer<DeltaHeader> processDeltaHeader, Consumer<DeltaElement> processDeltaElement) {
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLEventReader eventReader = factory.createXMLEventReader(inputStream);
            String sessionId = null;
            BigInteger serial = null;
            String uri = null;
            String hash = null;
            StringBuilder base64 = new StringBuilder();
            boolean inPublishElement = false;
            boolean deltaHeaderProcessed = false;
            Base64.Decoder decoder = Base64.getDecoder();
            while (eventReader.hasNext()) {
                XMLEvent event = eventReader.nextEvent();
                block1 : switch (event.getEventType()) {
                    case 1: {
                        String qName;
                        StartElement startElement = event.asStartElement();
                        switch (qName = startElement.getName().getLocalPart()) {
                            case "publish": {
                                if (!deltaHeaderProcessed) {
                                    throw new RrdpException("rrdp.parse.error", "delta header not present before elements");
                                }
                                uri = this.getAttr(startElement, "uri", "Uri is not present in 'publish' element");
                                hash = this.getAttr(startElement, "hash");
                                inPublishElement = true;
                                break block1;
                            }
                            case "withdraw": {
                                if (!deltaHeaderProcessed) {
                                    throw new RrdpException("rrdp.parse.error", "delta header not present before elements");
                                }
                                uri = this.getAttr(startElement, "uri", "Uri is not present in 'publish' element");
                                hash = this.getAttr(startElement, "hash", "Hash is not present in 'withdraw' element");
                                break block1;
                            }
                            case "delta": {
                                serial = new BigInteger(this.getAttr(startElement, "serial", "Notification serial is not present"));
                                sessionId = this.getAttr(startElement, "session_id", "Session id is not present");
                                processDeltaHeader.accept(new DeltaHeader(sessionId, serial));
                                deltaHeaderProcessed = true;
                            }
                        }
                        break;
                    }
                    case 4: {
                        Characters characters = event.asCharacters();
                        if (!inPublishElement) break;
                        String thisBase64 = characters.getData();
                        base64.append(thisBase64.replaceAll("\\s", ""));
                        break;
                    }
                    case 2: {
                        String qqName;
                        EndElement endElement = event.asEndElement();
                        switch (qqName = endElement.getName().getLocalPart()) {
                            case "publish": {
                                byte[] decoded = decoder.decode(base64.toString());
                                base64 = new StringBuilder();
                                processDeltaElement.accept((DeltaElement)new DeltaPublish(decoded, uri, Hex.parse((String)hash)));
                                break block1;
                            }
                            case "withdraw": {
                                processDeltaElement.accept((DeltaElement)new DeltaWithdraw(uri, Hex.parse(hash)));
                            }
                        }
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            throw new RrdpException("Couldn't parse delta: ", (Throwable)e);
        }
    }

    public Notification notification(InputStream inputStream) {
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLEventReader eventReader = factory.createXMLEventReader(inputStream);
            String sessionId = null;
            BigInteger serial = null;
            String snapshotUri = null;
            String snapshotHash = null;
            ArrayList<DeltaInfo> deltas = new ArrayList<DeltaInfo>();
            while (eventReader.hasNext()) {
                String qName;
                XMLEvent event = eventReader.nextEvent();
                if (event.getEventType() != 1) continue;
                StartElement startElement = event.asStartElement();
                switch (qName = startElement.getName().getLocalPart()) {
                    case "notification": {
                        serial = new BigInteger(this.getAttr(startElement, "serial", "Notification serial is not present"));
                        sessionId = this.getAttr(startElement, "session_id", "Session id is not present");
                        break;
                    }
                    case "snapshot": {
                        snapshotUri = this.getAttr(startElement, "uri", "Snapshot URI is not present");
                        snapshotHash = this.getAttr(startElement, "hash", "Snapshot hash is not present");
                        break;
                    }
                    case "delta": {
                        String deltaUri = this.getAttr(startElement, "uri", "Delta URI is not present");
                        String deltaHash = this.getAttr(startElement, "hash", "Delta hash is not present");
                        String deltaSerial = this.getAttr(startElement, "serial", "Delta serial is not present");
                        deltas.add(new DeltaInfo(deltaUri, deltaHash, new BigInteger(deltaSerial)));
                    }
                }
            }
            return new Notification(sessionId, serial, snapshotUri, snapshotHash, deltas);
        }
        catch (XMLStreamException e) {
            throw new RrdpException("Couldn't parse notification: ", (Throwable)e);
        }
    }

    private String getAttr(StartElement startElement, String attrName, String noAttrMessage) {
        String attr = this.getAttr(startElement, attrName);
        if (attr == null) {
            throw new RrdpException("rrdp.parse.error", noAttrMessage);
        }
        return attr;
    }

    private String getAttr(StartElement startElement, String attrName) {
        Iterator<Attribute> attributes = startElement.getAttributes();
        while (attributes.hasNext()) {
            Attribute next = attributes.next();
            String name = next.getName().getLocalPart();
            if (!attrName.equals(name)) continue;
            return next.getValue();
        }
        return null;
    }
}

