/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.domain.validation;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.util.CertificateRepositoryObjectFactory;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateUtil;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.rsync.CommandExecutionException;
import net.ripe.rpki.commons.validation.ValidationLocation;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.validator3.background.ValidationScheduler;
import net.ripe.rpki.validator3.domain.RpkiObjectUtils;
import net.ripe.rpki.validator3.domain.metrics.TrustAnchorMetricsService;
import net.ripe.rpki.validator3.domain.retrieval.TrustAnchorRetrievalService;
import net.ripe.rpki.validator3.domain.validation.RpkiRepositoryValidationService;
import net.ripe.rpki.validator3.storage.Storage;
import net.ripe.rpki.validator3.storage.Tx;
import net.ripe.rpki.validator3.storage.data.Key;
import net.ripe.rpki.validator3.storage.data.Ref;
import net.ripe.rpki.validator3.storage.data.RpkiRepository;
import net.ripe.rpki.validator3.storage.data.TrustAnchor;
import net.ripe.rpki.validator3.storage.data.validation.TrustAnchorValidationRun;
import net.ripe.rpki.validator3.storage.data.validation.ValidationCheck;
import net.ripe.rpki.validator3.storage.data.validation.ValidationRun;
import net.ripe.rpki.validator3.storage.stores.RpkiRepositories;
import net.ripe.rpki.validator3.storage.stores.TrustAnchors;
import net.ripe.rpki.validator3.storage.stores.ValidationRuns;
import org.jooq.lambda.tuple.Tuple2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TrustAnchorValidationService {
    private static final Logger log = LoggerFactory.getLogger(TrustAnchorValidationService.class);
    private final TrustAnchors trustAnchors;
    private final RpkiRepositories rpkiRepositories;
    private final ValidationRuns validationRuns;
    private final ValidationScheduler validationScheduler;
    private final RpkiRepositoryValidationService repositoryValidationService;
    private final Storage storage;
    private final TrustAnchorMetricsService taMetricsService;
    private final TrustAnchorRetrievalService trustAnchorRetrievalService;
    private Set<Key> validatedAtLeastOnce = Collections.newSetFromMap(new ConcurrentHashMap());

    @Autowired
    public TrustAnchorValidationService(TrustAnchors trustAnchors, RpkiRepositories rpkiRepositories, ValidationRuns validationRuns, ValidationScheduler validationScheduler, RpkiRepositoryValidationService repositoryValidationService, Storage storage, TrustAnchorMetricsService trustAnchorMetricsService, TrustAnchorRetrievalService trustAnchorRetrievalService) {
        this.trustAnchors = trustAnchors;
        this.rpkiRepositories = rpkiRepositories;
        this.validationRuns = validationRuns;
        this.validationScheduler = validationScheduler;
        this.repositoryValidationService = repositoryValidationService;
        this.storage = storage;
        this.taMetricsService = trustAnchorMetricsService;
        this.trustAnchorRetrievalService = trustAnchorRetrievalService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(long trustAnchorId) {
        Optional maybeTrustAnchor = (Optional)this.storage.readTx(tx -> this.trustAnchors.get(tx, Key.of((long)trustAnchorId)));
        if (!maybeTrustAnchor.isPresent()) {
            log.error("Trust anchor {} doesn't exist.", (Object)trustAnchorId);
            return;
        }
        TrustAnchor trustAnchor = (TrustAnchor)maybeTrustAnchor.get();
        log.info("trust anchor {} located at {} with subject public key info {}", new Object[]{trustAnchor.getName(), trustAnchor.getLocations(), trustAnchor.getSubjectPublicKeyInfo()});
        TrustAnchorValidationRun validationRun = (TrustAnchorValidationRun)this.storage.readTx(tx -> {
            Ref trustAnchorRef = this.trustAnchors.makeRef(tx, Key.of((long)trustAnchorId));
            return new TrustAnchorValidationRun(trustAnchorRef, (String)trustAnchor.getLocations().get(0));
        });
        ValidationLocation trustAnchorValidationLocation = new ValidationLocation(validationRun.getTrustAnchorCertificateURI());
        ValidationResult validationResult = RpkiObjectUtils.newValidationResult((ValidationLocation)trustAnchorValidationLocation);
        boolean updatedTrustAnchor = false;
        try {
            Optional maybeTrustAnchorCertificate = this.fetchPreferredTrustAnchorCertificate(trustAnchor, validationResult);
            if (maybeTrustAnchorCertificate.isPresent()) {
                Tuple2 res = (Tuple2)maybeTrustAnchorCertificate.get();
                updatedTrustAnchor = this.readTrustAnchorFromLocation((byte[])res.v2, trustAnchor, (URI)res.v1, validationResult);
            } else {
                validationResult.error("trust.anchor.fetch", new String[]{"any location", String.format("None of the locations (%s) could be loaded.", Joiner.on((String)", ").join((Iterable)trustAnchor.getLocations()))});
                validationRun.setFailed();
            }
            if (validationResult.hasFailures()) {
                log.warn("Validation result for the TA {} has failures: {}", (Object)trustAnchor.getName(), (Object)validationResult.getFailuresForAllLocations());
            }
            if (trustAnchor.getRsyncPrefetchUri() != null) {
                this.storage.writeTx0(tx -> {
                    Ref trustAnchorRef = this.trustAnchors.makeRef((Tx.Read)tx, trustAnchor.key());
                    this.rpkiRepositories.register(tx, trustAnchorRef, trustAnchor.getRsyncPrefetchUri(), RpkiRepository.Type.RSYNC_PREFETCH);
                });
            }
            validationRun.completeWith(validationResult);
            if (!this.validatedAtLeastOnce.contains(trustAnchor.getId()) || updatedTrustAnchor) {
                if (updatedTrustAnchor) {
                    this.storage.writeTx0(tx -> this.trustAnchors.update(tx, trustAnchor));
                }
                HashSet affectedTrustAnchors = Sets.newHashSet((Object[])new TrustAnchor[]{trustAnchor});
                if (trustAnchor.getRsyncPrefetchUri() != null) {
                    ((Optional)this.storage.readTx(tx -> this.rpkiRepositories.findByURI(tx, trustAnchor.getRsyncPrefetchUri()))).ifPresent(r -> affectedTrustAnchors.addAll(this.repositoryValidationService.prefetchRepository(r)));
                }
                affectedTrustAnchors.forEach(arg_0 -> ((ValidationScheduler)this.validationScheduler).triggerCertificateTreeValidation(arg_0));
            }
        }
        catch (IOException | CommandExecutionException e) {
            log.error("validation run for trust anchor {} failed", (Object)trustAnchor, (Object)e);
            validationRun.addCheck(new ValidationCheck(validationRun.getTrustAnchorCertificateURI(), ValidationCheck.Status.ERROR, "unhandled.exception", new String[]{e.toString()}));
            validationRun.setFailed();
        }
        finally {
            this.validatedAtLeastOnce.add(trustAnchor.getId());
            this.storage.writeTx0(tx -> {
                TrustAnchorValidationRun cfr_ignored_0 = (TrustAnchorValidationRun)this.validationRuns.add(tx, (ValidationRun)validationRun);
            });
        }
    }

    public Optional<Tuple2<URI, byte[]>> fetchPreferredTrustAnchorCertificate(TrustAnchor trustAnchor, ValidationResult validationResult) {
        ValidationLocation initialLocation = validationResult.getCurrentLocation();
        List rankedTrustAnchorLocations = trustAnchor.getLocationsByPreference();
        for (URI currentLocation : rankedTrustAnchorLocations) {
            validationResult.setLocation(new ValidationLocation(currentLocation));
            byte[] trustAnchorCertificate = this.trustAnchorRetrievalService.fetchTrustAnchorCertificate(currentLocation, validationResult);
            if (trustAnchorCertificate == null) continue;
            return Optional.of(new Tuple2((Object)currentLocation, (Object)trustAnchorCertificate));
        }
        validationResult.setLocation(initialLocation);
        return Optional.empty();
    }

    private boolean readTrustAnchorFromLocation(byte[] trustAnchorCertificate, TrustAnchor trustAnchor, URI trustAnchorCertificateURI, ValidationResult validationResult) throws IOException {
        long trustAnchorCertificateSize = trustAnchorCertificate.length;
        if (trustAnchorCertificateSize < 1L) {
            validationResult.error("repository.object.minimum.size", new String[]{trustAnchorCertificateURI.toASCIIString(), String.valueOf(trustAnchorCertificateSize), String.valueOf(1)});
        } else if (trustAnchorCertificateSize > 0xA00000L) {
            validationResult.error("repository.object.maximum.size", new String[]{trustAnchorCertificateURI.toASCIIString(), String.valueOf(trustAnchorCertificateSize), String.valueOf(0xA00000)});
        } else {
            X509ResourceCertificate parsedCertificate = this.parseCertificate(trustAnchor, trustAnchorCertificate, trustAnchorCertificateURI, validationResult);
            if (!validationResult.hasFailureForCurrentLocation()) {
                int comparedSerial = trustAnchor.getCertificate() == null ? 1 : parsedCertificate.getSerialNumber().compareTo(trustAnchor.getCertificate().getSerialNumber());
                validationResult.warnIfTrue(comparedSerial < 0, "repository.object.is.older.than.previous.object", new String[]{trustAnchorCertificateURI.toASCIIString()});
                if (comparedSerial != 0) {
                    log.info("Setting certificate {} for the TA {}", (Object)trustAnchorCertificateURI, (Object)trustAnchor.getName());
                    trustAnchor.setCertificate(parsedCertificate);
                    return true;
                }
            }
        }
        return false;
    }

    private X509ResourceCertificate parseCertificate(TrustAnchor trustAnchor, byte[] certificateData, URI trustAnchorCertificateURI, ValidationResult validationResult) throws IOException {
        boolean signatureValid;
        assert (trustAnchor.getLocationsByPreference().contains(trustAnchorCertificateURI));
        CertificateRepositoryObject trustAnchorCertificate = CertificateRepositoryObjectFactory.createCertificateRepositoryObject((byte[])certificateData, (ValidationResult)validationResult);
        validationResult.rejectIfFalse(trustAnchorCertificate instanceof X509ResourceCertificate, "repository.object.is.trust.anchor.certificate", new String[]{trustAnchorCertificateURI.toASCIIString()});
        if (validationResult.hasFailureForCurrentLocation()) {
            return null;
        }
        X509ResourceCertificate certificate = (X509ResourceCertificate)trustAnchorCertificate;
        String encodedSubjectPublicKeyInfo = X509CertificateUtil.getEncodedSubjectPublicKeyInfo((X509Certificate)certificate.getCertificate());
        validationResult.rejectIfFalse(encodedSubjectPublicKeyInfo.equals(trustAnchor.getSubjectPublicKeyInfo()), "trust.anchor.subject.key.matches.locator");
        try {
            certificate.getCertificate().verify(certificate.getPublicKey());
            signatureValid = true;
        }
        catch (GeneralSecurityException e) {
            signatureValid = false;
        }
        validationResult.rejectIfFalse(signatureValid, "trust.anchor.signature", new String[]{trustAnchorCertificateURI.toASCIIString(), trustAnchor.getSubjectPublicKeyInfo()});
        return certificate;
    }
}

