/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.api.slurm.dtos;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import net.ripe.rpki.validator3.api.slurm.dtos.Slurm;
import org.apache.commons.lang3.tuple.Pair;

/*
 * Exception performing whole class analysis ignored.
 */
public class SlurmExt {
    private Map<Long, Slurm.SlurmPrefixFilter> prefixFilters = new HashMap();
    private Map<Long, Slurm.SlurmBgpSecFilter> bgpsecFilters = new HashMap();
    private Map<Long, Slurm.SlurmPrefixAssertion> prefixAssertions = new HashMap();
    private Map<Long, Slurm.SlurmBgpSecAssertion> bgpsecAssertions = new HashMap();
    private static Comparator<Slurm.SlurmPrefixFilter> slurmPrefixFilterComparator = ((Comparator)(o1, o2) -> SlurmExt.compareWithNulls((Comparable)o1.getAsn(), (Comparable)o2.getAsn())).thenComparing((o1, o2) -> SlurmExt.compareWithNulls((Comparable)o1.getPrefix(), (Comparable)o2.getPrefix()));
    private static Comparator<Slurm.SlurmBgpSecFilter> slurmBgpSecFilterComparator = ((Comparator)(o1, o2) -> SlurmExt.compareWithNulls((Comparable)o1.getAsn(), (Comparable)o2.getAsn())).thenComparing((o1, o2) -> SlurmExt.compareWithNulls((Comparable)((Object)o1.getSki()), (Comparable)((Object)o2.getSki())));
    private static Comparator<Slurm.SlurmPrefixAssertion> slurmPrefixAssertionComparator = ((Comparator)(o1, o2) -> SlurmExt.compareWithNulls((Comparable)o1.getAsn(), (Comparable)o2.getAsn())).thenComparing((o1, o2) -> SlurmExt.compareWithNulls((Comparable)o1.getPrefix(), (Comparable)o2.getPrefix())).thenComparing((o1, o2) -> SlurmExt.compareWithNulls((Comparable)o1.getMaxPrefixLength(), (Comparable)o2.getMaxPrefixLength()));
    private static Comparator<Slurm.SlurmBgpSecAssertion> slurmBgpSecAssertionComparator = ((Comparator)(o1, o2) -> SlurmExt.compareWithNulls((Comparable)o1.getAsn(), (Comparable)o2.getAsn())).thenComparing((o1, o2) -> SlurmExt.compareWithNulls((Comparable)((Object)o1.getPublicKey()), (Comparable)((Object)o2.getPublicKey()))).thenComparing((o1, o2) -> SlurmExt.compareWithNulls((Comparable)((Object)o1.getSki()), (Comparable)((Object)o2.getSki())));

    public Slurm toSlurm() {
        Slurm slurm = new Slurm();
        slurm.setLocallyAddedAssertions(new Slurm.SlurmLocallyAddedAssertions(SlurmExt.extract((Map)this.prefixAssertions, (Comparator)slurmPrefixAssertionComparator), SlurmExt.extract((Map)this.bgpsecAssertions, (Comparator)slurmBgpSecAssertionComparator)));
        slurm.setValidationOutputFilters(new Slurm.SlurmOutputFilters(SlurmExt.extract((Map)this.prefixFilters, (Comparator)slurmPrefixFilterComparator), SlurmExt.extract((Map)this.bgpsecFilters, (Comparator)slurmBgpSecFilterComparator)));
        return slurm;
    }

    private static <T> List<T> extract(Map<Long, T> s, Comparator<T> comparator) {
        return s.values().stream().sorted(comparator).collect(Collectors.toList());
    }

    private static <T> Map<Long, T> addIds(List<T> s, AtomicLong idSeq, Comparator<T> comparator) {
        return s.stream().sorted(comparator).map(v -> Pair.of((Object)idSeq.getAndIncrement(), (Object)v)).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
    }

    private static <T extends Comparable<T>> int compareWithNulls(T asn1, T asn2) {
        if (asn1 == null) {
            return asn2 == null ? 0 : 1;
        }
        return asn2 == null ? -1 : asn1.compareTo(asn2);
    }

    public static SlurmExt fromSlurm(Slurm slurm, AtomicLong idSeq) {
        SlurmExt slurmExt = new SlurmExt();
        slurmExt.setPrefixFilters(SlurmExt.addIds((List)slurm.getValidationOutputFilters().getPrefixFilters(), (AtomicLong)idSeq, (Comparator)slurmPrefixFilterComparator));
        slurmExt.setBgpsecFilters(SlurmExt.addIds((List)slurm.getValidationOutputFilters().getBgpsecFilters(), (AtomicLong)idSeq, (Comparator)slurmBgpSecFilterComparator));
        slurmExt.setPrefixAssertions(SlurmExt.addIds((List)slurm.getLocallyAddedAssertions().getPrefixAssertions(), (AtomicLong)idSeq, (Comparator)slurmPrefixAssertionComparator));
        slurmExt.setBgpsecAssertions(SlurmExt.addIds((List)slurm.getLocallyAddedAssertions().getBgpsecAssertions(), (AtomicLong)idSeq, (Comparator)slurmBgpSecAssertionComparator));
        return slurmExt;
    }

    public SlurmExt copy() {
        SlurmExt slurmExt = new SlurmExt();
        slurmExt.setPrefixFilters(new HashMap(this.prefixFilters));
        slurmExt.setBgpsecFilters(new HashMap(this.bgpsecFilters));
        slurmExt.setPrefixAssertions(new HashMap(this.prefixAssertions));
        slurmExt.setBgpsecAssertions(new HashMap(this.bgpsecAssertions));
        return slurmExt;
    }

    public Map<Long, Slurm.SlurmPrefixFilter> getPrefixFilters() {
        return this.prefixFilters;
    }

    public Map<Long, Slurm.SlurmBgpSecFilter> getBgpsecFilters() {
        return this.bgpsecFilters;
    }

    public Map<Long, Slurm.SlurmPrefixAssertion> getPrefixAssertions() {
        return this.prefixAssertions;
    }

    public Map<Long, Slurm.SlurmBgpSecAssertion> getBgpsecAssertions() {
        return this.bgpsecAssertions;
    }

    public void setPrefixFilters(Map<Long, Slurm.SlurmPrefixFilter> prefixFilters) {
        this.prefixFilters = prefixFilters;
    }

    public void setBgpsecFilters(Map<Long, Slurm.SlurmBgpSecFilter> bgpsecFilters) {
        this.bgpsecFilters = bgpsecFilters;
    }

    public void setPrefixAssertions(Map<Long, Slurm.SlurmPrefixAssertion> prefixAssertions) {
        this.prefixAssertions = prefixAssertions;
    }

    public void setBgpsecAssertions(Map<Long, Slurm.SlurmBgpSecAssertion> bgpsecAssertions) {
        this.bgpsecAssertions = bgpsecAssertions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SlurmExt)) {
            return false;
        }
        SlurmExt other = (SlurmExt)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Map this$prefixFilters = this.getPrefixFilters();
        Map other$prefixFilters = other.getPrefixFilters();
        if (this$prefixFilters == null ? other$prefixFilters != null : !((Object)this$prefixFilters).equals(other$prefixFilters)) {
            return false;
        }
        Map this$bgpsecFilters = this.getBgpsecFilters();
        Map other$bgpsecFilters = other.getBgpsecFilters();
        if (this$bgpsecFilters == null ? other$bgpsecFilters != null : !((Object)this$bgpsecFilters).equals(other$bgpsecFilters)) {
            return false;
        }
        Map this$prefixAssertions = this.getPrefixAssertions();
        Map other$prefixAssertions = other.getPrefixAssertions();
        if (this$prefixAssertions == null ? other$prefixAssertions != null : !((Object)this$prefixAssertions).equals(other$prefixAssertions)) {
            return false;
        }
        Map this$bgpsecAssertions = this.getBgpsecAssertions();
        Map other$bgpsecAssertions = other.getBgpsecAssertions();
        return !(this$bgpsecAssertions == null ? other$bgpsecAssertions != null : !((Object)this$bgpsecAssertions).equals(other$bgpsecAssertions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SlurmExt;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map $prefixFilters = this.getPrefixFilters();
        result = result * 59 + ($prefixFilters == null ? 43 : ((Object)$prefixFilters).hashCode());
        Map $bgpsecFilters = this.getBgpsecFilters();
        result = result * 59 + ($bgpsecFilters == null ? 43 : ((Object)$bgpsecFilters).hashCode());
        Map $prefixAssertions = this.getPrefixAssertions();
        result = result * 59 + ($prefixAssertions == null ? 43 : ((Object)$prefixAssertions).hashCode());
        Map $bgpsecAssertions = this.getBgpsecAssertions();
        result = result * 59 + ($bgpsecAssertions == null ? 43 : ((Object)$bgpsecAssertions).hashCode());
        return result;
    }

    public String toString() {
        return "SlurmExt(prefixFilters=" + this.getPrefixFilters() + ", bgpsecFilters=" + this.getBgpsecFilters() + ", prefixAssertions=" + this.getPrefixAssertions() + ", bgpsecAssertions=" + this.getBgpsecAssertions() + ")";
    }
}

