/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.rrdp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Function;
import net.ripe.rpki.validator3.api.util.BuildInformation;
import net.ripe.rpki.validator3.domain.metrics.HttpClientMetricsService;
import net.ripe.rpki.validator3.rrdp.RrdpClient;
import net.ripe.rpki.validator3.rrdp.RrdpException;
import net.ripe.rpki.validator3.util.HttpStreaming;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StreamUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class HttpRrdpClient
implements RrdpClient {
    private static final Logger log = LoggerFactory.getLogger(HttpRrdpClient.class);
    private final HttpClientMetricsService httpMetrics;
    private HttpClient httpClient;
    private final BuildInformation buildInformation;

    @Autowired
    public HttpRrdpClient(HttpClient httpClient, HttpClientMetricsService httpMetrics, BuildInformation buildInformation) {
        this.httpClient = httpClient;
        this.buildInformation = buildInformation;
        this.httpMetrics = httpMetrics;
    }

    public <T> T readStream(String uri, Function<InputStream, T> reader) {
        long before = System.currentTimeMillis();
        String statusDescription = "200";
        try {
            Object object = HttpStreaming.readStream(() -> {
                Request request = this.httpClient.newRequest(uri);
                String version = this.buildInformation.getVersion();
                return request;
            }, reader);
            return (T)object;
        }
        catch (Exception e) {
            statusDescription = HttpClientMetricsService.unwrapExceptionString((Throwable)e);
            throw new RrdpException("Error downloading '" + uri + "', cause: " + HttpRrdpClient.fullMessage((Throwable)e), (Throwable)e);
        }
        finally {
            this.httpMetrics.update(uri, statusDescription, System.currentTimeMillis() - before);
        }
    }

    private static String fullMessage(Throwable t) {
        StringBuilder s = new StringBuilder();
        while (true) {
            s.append(t.getMessage());
            if (t == t.getCause()) {
                return s.toString();
            }
            if ((t = t.getCause()) == null) {
                return s.toString();
            }
            s.append(", cause: ");
        }
    }

    public byte[] getBody(String uri) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.readStream(uri, s -> {
            try {
                return StreamUtils.copy((InputStream)s, (OutputStream)baos);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        return baos.toByteArray();
    }
}

