/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.domain.retrieval;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import net.ripe.rpki.commons.rsync.Rsync;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.validator3.api.util.BuildInformation;
import net.ripe.rpki.validator3.domain.metrics.HttpClientMetricsService;
import net.ripe.rpki.validator3.domain.metrics.RsyncMetricsService;
import net.ripe.rpki.validator3.util.RsyncFactory;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class TrustAnchorRetrievalService {
    private static final Logger log = LoggerFactory.getLogger(TrustAnchorRetrievalService.class);
    private boolean isFileProtocolEnabled = false;
    @Value(value="${rpki.validator.rsync.local.storage.directory}")
    private File localRsyncStorageDirectory;
    @Autowired
    private BuildInformation buildInformation;
    @Autowired
    private RsyncFactory rsyncFactory;
    @Autowired
    private HttpClient httpClient;
    @Autowired
    private HttpClientMetricsService httpMetrics;
    @Autowired
    private RsyncMetricsService rsyncMetrics;

    public byte[] fetchTrustAnchorCertificate(URI trustAnchorCertificateURI, ValidationResult validationResult) {
        try {
            switch (trustAnchorCertificateURI.getScheme()) {
                case "rsync": {
                    return this.fetchRsyncTrustAnchorCertificate(trustAnchorCertificateURI, validationResult);
                }
                case "https": {
                    return this.fetchHttpsTrustAnchorCertificate(trustAnchorCertificateURI, validationResult);
                }
                case "file": {
                    return this.fetchFileTrustAnchorCertificate(trustAnchorCertificateURI, validationResult);
                }
            }
            validationResult.warn("trust.anchor.fetch", new String[]{trustAnchorCertificateURI.toASCIIString(), "Unsupported URI"});
            return null;
        }
        catch (IOException e) {
            validationResult.warn("trust.anchor.fetch", new String[]{trustAnchorCertificateURI.toASCIIString(), e.getMessage()});
            return null;
        }
    }

    private byte[] fetchFileTrustAnchorCertificate(URI trustAnchorCertificateURI, ValidationResult validationResult) throws IOException {
        if (this.isFileProtocolEnabled) {
            return Files.toByteArray((File)new File(trustAnchorCertificateURI));
        }
        validationResult.error("trust.anchor.fetch", new String[]{trustAnchorCertificateURI.toASCIIString(), "File support not explicitly enabled."});
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] fetchHttpsTrustAnchorCertificate(URI trustAnchorCertificateURI, ValidationResult validationResult) {
        long t0 = System.currentTimeMillis();
        String statusDescription = "unknown";
        try {
            ContentResponse res = this.httpClient.newRequest(trustAnchorCertificateURI).send();
            log.debug("HTTP {} when fetching HTTPS trust anchor from {}", (Object)res.getStatus(), (Object)trustAnchorCertificateURI);
            statusDescription = String.valueOf(res.getStatus());
            if (res.getStatus() != 200) {
                validationResult.warn("trust.anchor.fetch", new String[]{trustAnchorCertificateURI.toASCIIString(), String.format("HTTP %d - %s", res.getStatus(), res.getReason())});
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = res.getContent();
            return byArray;
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            validationResult.warn("trust.anchor.fetch", new String[]{trustAnchorCertificateURI.toASCIIString(), e.getMessage()});
            statusDescription = HttpClientMetricsService.unwrapExceptionString((Throwable)e);
            log.error("Error while loading trust anchor certificate over https", (Throwable)e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            this.httpMetrics.update(trustAnchorCertificateURI, statusDescription, System.currentTimeMillis() - t0);
        }
    }

    protected byte[] fetchRsyncTrustAnchorCertificate(URI trustAnchorCertificateURI, ValidationResult validationResult) throws IOException {
        long t0 = System.currentTimeMillis();
        File targetFile = net.ripe.rpki.validator3.util.Rsync.localFileFromRsyncUri((File)this.localRsyncStorageDirectory, (URI)trustAnchorCertificateURI);
        if (targetFile.getParentFile().mkdirs()) {
            log.info("created local rsync storage directory {} for trust anchor {}", (Object)targetFile.getParentFile(), (Object)trustAnchorCertificateURI);
        }
        Rsync rsync = this.rsyncFactory.rsyncFile(trustAnchorCertificateURI.toASCIIString(), targetFile.getPath());
        int exitStatus = rsync.execute();
        this.rsyncMetrics.update(trustAnchorCertificateURI, exitStatus, System.currentTimeMillis() - t0);
        if (exitStatus != 0) {
            validationResult.warn("rsync.fetch", new String[]{String.valueOf(exitStatus), ArrayUtils.toString((Object)rsync.getErrorLines())});
            return null;
        }
        log.info("Downloaded certificate {} to {}", (Object)trustAnchorCertificateURI, (Object)targetFile);
        return Files.toByteArray((File)targetFile);
    }

    public void setFileProtocolEnabled(boolean isFileProtocolEnabled) {
        this.isFileProtocolEnabled = isFileProtocolEnabled;
    }

    public void setLocalRsyncStorageDirectory(File localRsyncStorageDirectory) {
        this.localRsyncStorageDirectory = localRsyncStorageDirectory;
    }

    public void setBuildInformation(BuildInformation buildInformation) {
        this.buildInformation = buildInformation;
    }

    public void setRsyncFactory(RsyncFactory rsyncFactory) {
        this.rsyncFactory = rsyncFactory;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void setHttpMetrics(HttpClientMetricsService httpMetrics) {
        this.httpMetrics = httpMetrics;
    }

    public void setRsyncMetrics(RsyncMetricsService rsyncMetrics) {
        this.rsyncMetrics = rsyncMetrics;
    }
}

