/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.api.bgpsec;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.Valid;
import net.ripe.ipresource.Asn;
import net.ripe.rpki.validator3.api.bgpsec.AddBgpSecFilter;
import net.ripe.rpki.validator3.api.bgpsec.BgpSecFilter;
import net.ripe.rpki.validator3.api.slurm.SlurmStore;
import net.ripe.rpki.validator3.api.slurm.dtos.Slurm;
import net.ripe.rpki.validator3.domain.validation.ValidatedRpkiObjects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

@Component
@Validated
public class BgpSecFilterService {
    private static final Logger log = LoggerFactory.getLogger(BgpSecFilterService.class);
    private final SlurmStore slurmStore;

    @Autowired
    public BgpSecFilterService(SlurmStore slurmStore) {
        this.slurmStore = slurmStore;
    }

    public long execute(@Valid AddBgpSecFilter command) {
        long id = this.slurmStore.nextId();
        return (Long)this.slurmStore.updateWith(slurmExt -> {
            Slurm.SlurmBgpSecFilter slurmBgpSecFilter = new Slurm.SlurmBgpSecFilter();
            slurmBgpSecFilter.setAsn(Long.valueOf(Asn.parse((String)command.getAsn()).longValue()));
            slurmBgpSecFilter.setSki(command.getSki());
            slurmBgpSecFilter.setComment(command.getComment());
            slurmExt.getBgpsecFilters().put(id, slurmBgpSecFilter);
            return id;
        });
    }

    public void remove(long id) {
        this.slurmStore.updateWith(slurmExt -> slurmExt.getBgpsecFilters().remove(id));
    }

    public Stream<BgpSecFilter> all() {
        return this.slurmStore.read().getBgpsecFilters().entrySet().stream().map(e -> {
            Slurm.SlurmBgpSecFilter v = (Slurm.SlurmBgpSecFilter)e.getValue();
            return new BgpSecFilter((Long)e.getKey(), v.getAsn(), v.getSki(), v.getComment());
        });
    }

    public void clear() {
        this.slurmStore.updateWith(slurmExt -> slurmExt.getBgpsecFilters().clear());
    }

    public Stream<ValidatedRpkiObjects.RouterCertificate> filterCertificates(Stream<ValidatedRpkiObjects.RouterCertificate> routerCertificates) {
        return this.filterCertificates(routerCertificates, this.all().collect(Collectors.toList()));
    }

    Stream<ValidatedRpkiObjects.RouterCertificate> filterCertificates(Stream<ValidatedRpkiObjects.RouterCertificate> routerCertificates, List<BgpSecFilter> filters) {
        return routerCertificates.filter(rc -> {
            List longAsns = rc.getAsn() != null ? rc.getAsn().stream().map(asn -> Asn.parse((String)asn).longValue()).collect(Collectors.toList()) : Collections.emptyList();
            return filters.stream().noneMatch(f -> {
                boolean keepIt = true;
                Long asn = f.getAsn();
                if (asn != null) {
                    keepIt = longAsns.stream().anyMatch(a -> a.longValue() == asn.longValue());
                }
                if (f.getSki() != null) {
                    keepIt = keepIt && f.getSki().equals(rc.getSubjectKeyIdentifier());
                }
                return keepIt;
            });
        });
    }
}

