/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.storage.data;

import com.google.common.primitives.Longs;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import net.ripe.rpki.validator3.storage.Binary;
import net.ripe.rpki.validator3.storage.Bytes;
import net.ripe.rpki.validator3.util.Hex;

/*
 * Exception performing whole class analysis ignored.
 */
@Binary
public class Key
implements Serializable {
    private final byte[] bytes;

    public Key(ByteBuffer bb) {
        this.bytes = Bytes.toBytes((ByteBuffer)bb);
    }

    public Key(ByteIterable bi) {
        this.bytes = Bytes.toBytes((ByteIterable)bi);
    }

    private Key(byte[] bytes) {
        this.bytes = Arrays.copyOf(bytes, bytes.length);
    }

    public Key(long long_) {
        this.bytes = Longs.toByteArray((long)long_);
    }

    public static Key of(byte[] bytes) {
        return new Key(bytes);
    }

    public static Key of(long l) {
        return new Key(l);
    }

    public static Key of(String s) {
        return Key.of((byte[])s.getBytes(StandardCharsets.UTF_8));
    }

    public static Key of(BigInteger bi) {
        return Key.of((byte[])bi.toByteArray());
    }

    public static Key of(UUID uuid) {
        ByteBuffer bb = ByteBuffer.allocateDirect(16);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        bb.flip();
        return new Key(bb);
    }

    public static Set<Key> keys(Key k) {
        return Collections.singleton(k);
    }

    public ByteBuffer toByteBuffer() {
        return Bytes.toDirectBuffer((byte[])this.bytes);
    }

    public ByteIterable toByteIterable() {
        return new ArrayByteIterable(this.bytes);
    }

    public int size() {
        return this.bytes.length;
    }

    public Key concat(Key key) {
        return Key.concatAll((Key[])new Key[]{this, key});
    }

    private static Key concatAll(Key ... keys) {
        int size = Arrays.stream(keys).mapToInt(Key::size).sum();
        ByteBuffer combined = ByteBuffer.allocate(size);
        Arrays.stream(keys).forEach(k -> combined.put(k.bytes));
        return new Key(combined);
    }

    public String toString() {
        return Hex.format((byte[])this.bytes);
    }

    public long asLong() {
        return Longs.fromByteArray((byte[])this.bytes);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Key)) {
            return false;
        }
        Key other = (Key)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return Arrays.equals(this.getBytes(), other.getBytes());
    }

    protected boolean canEqual(Object other) {
        return other instanceof Key;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getBytes());
        return result;
    }

    public byte[] getBytes() {
        return this.bytes;
    }
}

