/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.domain.cleanup;

import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.concurrent.atomic.AtomicInteger;
import net.ripe.rpki.validator3.api.util.InstantWithoutNanos;
import net.ripe.rpki.validator3.storage.Storage;
import net.ripe.rpki.validator3.storage.stores.ValidationRuns;
import net.ripe.rpki.validator3.util.Time;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ValidationRunCleanupService {
    private static final Logger log = LoggerFactory.getLogger(ValidationRunCleanupService.class);
    @Autowired
    private ValidationRuns validationRuns;
    private final Duration cleanupGraceDuration;
    private final Storage storage;

    public ValidationRunCleanupService(@Value(value="${rpki.validator.validation.run.cleanup.grace.duration}") String cleanupGraceDuration, Storage storage) {
        this.cleanupGraceDuration = Duration.parse(cleanupGraceDuration);
        this.storage = storage;
    }

    public Pair<AtomicInteger, AtomicInteger> cleanupValidationRuns() {
        AtomicInteger oldCount = new AtomicInteger();
        AtomicInteger orphanCount = new AtomicInteger();
        InstantWithoutNanos completedBefore = InstantWithoutNanos.now().minus((TemporalAmount)this.cleanupGraceDuration);
        Long t = Time.timed(() -> {
            oldCount.set((Integer)this.storage.writeTx(tx -> this.validationRuns.removeOldValidationRuns(tx, completedBefore)));
            orphanCount.set((Integer)this.storage.writeTx(tx -> this.validationRuns.removeOrphanValidationRunAssociations(tx)));
        });
        log.info("Removed {} old validation runs and {} orphans in {}ms", new Object[]{oldCount.get(), orphanCount.get(), t});
        this.storage.gc();
        return Pair.of((Object)oldCount, (Object)orphanCount);
    }
}

