/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.storage.encoding.custom.validation;

import java.util.Map;
import net.ripe.rpki.validator3.storage.data.Ref;
import net.ripe.rpki.validator3.storage.data.TrustAnchor;
import net.ripe.rpki.validator3.storage.data.validation.TrustAnchorValidationRun;
import net.ripe.rpki.validator3.storage.data.validation.ValidationRun;
import net.ripe.rpki.validator3.storage.encoding.Coder;
import net.ripe.rpki.validator3.storage.encoding.custom.Coders;
import net.ripe.rpki.validator3.storage.encoding.custom.Encoded;
import net.ripe.rpki.validator3.storage.encoding.custom.RefCoder;
import net.ripe.rpki.validator3.storage.encoding.custom.Tags;
import net.ripe.rpki.validator3.storage.encoding.custom.validation.ValidationRunCoder;

public class TAValidationRunCoder
implements Coder<TrustAnchorValidationRun> {
    private static final short TA_TAG = Tags.unique((int)101);
    private static final short URI_TAG = Tags.unique((int)102);
    private static final RefCoder<TrustAnchor> taRefCoder = new RefCoder();

    public byte[] toBytes(TrustAnchorValidationRun validationRun) {
        Encoded encoded = new Encoded();
        ValidationRunCoder.toBytes((ValidationRun)validationRun, (Encoded)encoded);
        encoded.appendNotNull(TA_TAG, (Object)validationRun.getTrustAnchor(), arg_0 -> ((RefCoder)taRefCoder).toBytes(arg_0));
        encoded.appendNotNull(URI_TAG, (Object)validationRun.getTrustAnchorCertificateURI(), Coders::toBytes);
        return encoded.toByteArray();
    }

    public TrustAnchorValidationRun fromBytes(byte[] bytes) {
        Map content = Encoded.fromByteArray((byte[])bytes).getContent();
        Ref trustAnchorRef = taRefCoder.fromBytes((byte[])content.get(TA_TAG));
        String uri = Coders.toString((byte[])((byte[])content.get(URI_TAG)));
        TrustAnchorValidationRun validationRun = new TrustAnchorValidationRun(trustAnchorRef, uri);
        ValidationRunCoder.fromBytes((Map)content, (ValidationRun)validationRun);
        return validationRun;
    }
}

