/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.storage.encoding.custom;

import java.util.Map;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpRange;
import net.ripe.rpki.validator3.api.bgp.PackedIpRange;
import net.ripe.rpki.validator3.storage.data.Base;
import net.ripe.rpki.validator3.storage.data.RoaPrefix;
import net.ripe.rpki.validator3.storage.encoding.Coder;
import net.ripe.rpki.validator3.storage.encoding.custom.BaseCoder;
import net.ripe.rpki.validator3.storage.encoding.custom.Coders;
import net.ripe.rpki.validator3.storage.encoding.custom.Encoded;
import net.ripe.rpki.validator3.storage.encoding.custom.Tags;

public class RoaPrefixCoder
implements Coder<RoaPrefix> {
    private static final short PREFIX_TAG = Tags.unique((int)21);
    private static final short ASN_TAG = Tags.unique((int)22);
    private static final short MAX_LEN_TAG = Tags.unique((int)23);

    public byte[] toBytes(RoaPrefix roaPrefix) {
        Encoded encoded = new Encoded();
        BaseCoder.toBytes((Base)roaPrefix, (Encoded)encoded);
        encoded.append(PREFIX_TAG, new PackedIpRange(roaPrefix.getPrefix()).getContent());
        encoded.append(ASN_TAG, Coders.toBytes((long)roaPrefix.getAsn()));
        encoded.appendNotNull(MAX_LEN_TAG, (Object)roaPrefix.getMaximumLength(), Coders::toBytes);
        return encoded.toByteArray();
    }

    public RoaPrefix fromBytes(byte[] bytes) {
        Map content = Encoded.fromByteArray((byte[])bytes).getContent();
        IpRange prefix = PackedIpRange.of((byte[])((byte[])content.get(PREFIX_TAG)));
        long asn = Coders.toLong((byte[])((byte[])content.get(ASN_TAG)));
        byte[] maxLen = (byte[])content.get(MAX_LEN_TAG);
        Integer maximumLength = maxLen != null ? Integer.valueOf(Coders.toInt((byte[])maxLen)) : null;
        RoaPrefix roaPrefix = RoaPrefix.of((IpRange)prefix, (Integer)maximumLength, (Asn)new Asn(asn));
        BaseCoder.fromBytes((Map)content, (Base)roaPrefix);
        return roaPrefix;
    }
}

