/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.storage.stores.impl;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Map;
import net.ripe.rpki.validator3.storage.IxMap;
import net.ripe.rpki.validator3.storage.Storage;
import net.ripe.rpki.validator3.storage.Tx;
import net.ripe.rpki.validator3.storage.data.Key;
import net.ripe.rpki.validator3.storage.encoding.Coder;
import net.ripe.rpki.validator3.storage.encoding.StringCoder;
import net.ripe.rpki.validator3.storage.stores.GenericStoreImpl;
import net.ripe.rpki.validator3.storage.stores.Settings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SettingsStore
extends GenericStoreImpl<String>
implements Settings {
    private static final String INITIAL_VALIDATION_RUN_COMPLETED = "internal.initial.validation.run.completed";
    private static final String SETTINGS = "settings";
    private final IxMap<String> ixMap;

    @Autowired
    public SettingsStore(Storage storage) {
        this.ixMap = storage.createIxMap(SETTINGS, (Map)ImmutableMap.of(), (Coder)new StringCoder());
    }

    public void markInitialValidationRunCompleted(Tx.Write tx) {
        this.setTrue(tx, INITIAL_VALIDATION_RUN_COMPLETED);
    }

    public boolean isInitialValidationRunCompleted(Tx.Read tx) {
        return this.isTrue(tx);
    }

    public void setTrue(Tx.Write tx, String preconfiguredTalSettingsKey) {
        this.ixMap.put(tx, Key.of((String)preconfiguredTalSettingsKey), (Serializable)((Object)"true"));
    }

    private boolean isTrue(Tx.Read tx) {
        return this.ixMap.get(tx, Key.of((String)INITIAL_VALIDATION_RUN_COMPLETED)).filter("true"::equals).isPresent();
    }

    protected IxMap<String> ixMap() {
        return this.ixMap;
    }
}

