/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.storage.data;

import javax.validation.constraints.NotNull;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpRange;
import net.ripe.ipresource.IpResourceType;
import net.ripe.rpki.validator3.storage.Binary;
import net.ripe.rpki.validator3.storage.data.Base;

@Binary
public class RoaPrefix
extends Base<RoaPrefix> {
    public static final byte FAMILY_IPV4 = 4;
    public static final byte FAMILY_IPV6 = 6;
    @NotNull
    IpRange prefix;
    byte prefixFamily;
    Integer maximumLength;
    int effectiveLength;
    long asn;

    public static RoaPrefix of(IpRange prefix, Integer maximumLength, Asn asn) {
        RoaPrefix result = new RoaPrefix();
        result.setPrefix(prefix);
        result.setPrefixFamily(prefix.getType() == IpResourceType.IPv4 ? (byte)4 : 6);
        result.setMaximumLength(maximumLength);
        result.setEffectiveLength(maximumLength != null ? maximumLength.intValue() : prefix.getPrefixLength());
        result.setAsn(asn.longValue());
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RoaPrefix)) {
            return false;
        }
        RoaPrefix other = (RoaPrefix)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IpRange this$prefix = this.getPrefix();
        IpRange other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        if (this.getPrefixFamily() != other.getPrefixFamily()) {
            return false;
        }
        Integer this$maximumLength = this.getMaximumLength();
        Integer other$maximumLength = other.getMaximumLength();
        if (this$maximumLength == null ? other$maximumLength != null : !((Object)this$maximumLength).equals(other$maximumLength)) {
            return false;
        }
        if (this.getEffectiveLength() != other.getEffectiveLength()) {
            return false;
        }
        return this.getAsn() == other.getAsn();
    }

    protected boolean canEqual(Object other) {
        return other instanceof RoaPrefix;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        IpRange $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        result = result * 59 + this.getPrefixFamily();
        Integer $maximumLength = this.getMaximumLength();
        result = result * 59 + ($maximumLength == null ? 43 : ((Object)$maximumLength).hashCode());
        result = result * 59 + this.getEffectiveLength();
        long $asn = this.getAsn();
        result = result * 59 + (int)($asn >>> 32 ^ $asn);
        return result;
    }

    public IpRange getPrefix() {
        return this.prefix;
    }

    public byte getPrefixFamily() {
        return this.prefixFamily;
    }

    public Integer getMaximumLength() {
        return this.maximumLength;
    }

    public int getEffectiveLength() {
        return this.effectiveLength;
    }

    public long getAsn() {
        return this.asn;
    }

    public void setPrefix(IpRange prefix) {
        this.prefix = prefix;
    }

    public void setPrefixFamily(byte prefixFamily) {
        this.prefixFamily = prefixFamily;
    }

    public void setMaximumLength(Integer maximumLength) {
        this.maximumLength = maximumLength;
    }

    public void setEffectiveLength(int effectiveLength) {
        this.effectiveLength = effectiveLength;
    }

    public void setAsn(long asn) {
        this.asn = asn;
    }

    public String toString() {
        return "RoaPrefix(prefix=" + this.getPrefix() + ", prefixFamily=" + this.getPrefixFamily() + ", maximumLength=" + this.getMaximumLength() + ", effectiveLength=" + this.getEffectiveLength() + ", asn=" + this.getAsn() + ")";
    }
}

