/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.api.trustanchors;

import io.swagger.annotations.ApiModelProperty;
import java.beans.ConstructorProperties;
import java.util.List;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import net.ripe.rpki.validator3.api.trustanchors.AddTrustAnchor;
import net.ripe.rpki.validator3.domain.constraints.ValidLocationURI;
import net.ripe.rpki.validator3.domain.constraints.ValidPublicKeyInfo;

class AddTrustAnchor {
    @NotNull
    @Pattern(regexp="^trust-anchor$")
    @ApiModelProperty(allowableValues="trust-anchor", required=true, position=1)
    @NotNull @Pattern(regexp="^trust-anchor$") String type;
    @NotNull
    @NotEmpty
    @ApiModelProperty(required=true, position=2)
    String name;
    @NotNull
    @NotEmpty
    @Size(max=1)
    @ApiModelProperty(required=true, position=3)
    @NotNull @NotEmpty @Size(max=1) List<@NotNull @ValidLocationURI String> locations;
    @NotNull
    @ValidPublicKeyInfo
    @ApiModelProperty(required=true, position=4)
    String subjectPublicKeyInfo;
    @ValidLocationURI
    @ApiModelProperty(required=false, position=5)
    String rsyncPrefetchUri;

    @ConstructorProperties(value={"type", "name", "locations", "subjectPublicKeyInfo", "rsyncPrefetchUri"})
    AddTrustAnchor(String type, String name, List<String> locations, String subjectPublicKeyInfo, String rsyncPrefetchUri) {
        this.type = type;
        this.name = name;
        this.locations = locations;
        this.subjectPublicKeyInfo = subjectPublicKeyInfo;
        this.rsyncPrefetchUri = rsyncPrefetchUri;
    }

    public static AddTrustAnchorBuilder builder() {
        return new AddTrustAnchorBuilder();
    }

    private AddTrustAnchor() {
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getLocations() {
        return this.locations;
    }

    public String getSubjectPublicKeyInfo() {
        return this.subjectPublicKeyInfo;
    }

    public String getRsyncPrefetchUri() {
        return this.rsyncPrefetchUri;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLocations(List<String> locations) {
        this.locations = locations;
    }

    public void setSubjectPublicKeyInfo(String subjectPublicKeyInfo) {
        this.subjectPublicKeyInfo = subjectPublicKeyInfo;
    }

    public void setRsyncPrefetchUri(String rsyncPrefetchUri) {
        this.rsyncPrefetchUri = rsyncPrefetchUri;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddTrustAnchor)) {
            return false;
        }
        AddTrustAnchor other = (AddTrustAnchor)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List this$locations = this.getLocations();
        List other$locations = other.getLocations();
        if (this$locations == null ? other$locations != null : !((Object)this$locations).equals(other$locations)) {
            return false;
        }
        String this$subjectPublicKeyInfo = this.getSubjectPublicKeyInfo();
        String other$subjectPublicKeyInfo = other.getSubjectPublicKeyInfo();
        if (this$subjectPublicKeyInfo == null ? other$subjectPublicKeyInfo != null : !this$subjectPublicKeyInfo.equals(other$subjectPublicKeyInfo)) {
            return false;
        }
        String this$rsyncPrefetchUri = this.getRsyncPrefetchUri();
        String other$rsyncPrefetchUri = other.getRsyncPrefetchUri();
        return !(this$rsyncPrefetchUri == null ? other$rsyncPrefetchUri != null : !this$rsyncPrefetchUri.equals(other$rsyncPrefetchUri));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AddTrustAnchor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List $locations = this.getLocations();
        result = result * 59 + ($locations == null ? 43 : ((Object)$locations).hashCode());
        String $subjectPublicKeyInfo = this.getSubjectPublicKeyInfo();
        result = result * 59 + ($subjectPublicKeyInfo == null ? 43 : $subjectPublicKeyInfo.hashCode());
        String $rsyncPrefetchUri = this.getRsyncPrefetchUri();
        result = result * 59 + ($rsyncPrefetchUri == null ? 43 : $rsyncPrefetchUri.hashCode());
        return result;
    }

    public String toString() {
        return "AddTrustAnchor(type=" + this.getType() + ", name=" + this.getName() + ", locations=" + this.getLocations() + ", subjectPublicKeyInfo=" + this.getSubjectPublicKeyInfo() + ", rsyncPrefetchUri=" + this.getRsyncPrefetchUri() + ")";
    }
}

