/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.api.roaprefixassertions;

import io.swagger.annotations.ApiModelProperty;
import java.beans.ConstructorProperties;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import net.ripe.rpki.validator3.api.roaprefixassertions.AddRoaPrefixAssertion;
import net.ripe.rpki.validator3.domain.constraints.ValidAddRoaPrefixAssertion;
import net.ripe.rpki.validator3.domain.constraints.ValidAsn;
import net.ripe.rpki.validator3.domain.constraints.ValidPrefix;

@ValidAddRoaPrefixAssertion
public class AddRoaPrefixAssertion {
    @ApiModelProperty(position=1, required=true, value="ASN to match (without AS prefix)", example="3333")
    @NotNull
    @ValidAsn
    String asn;
    @ApiModelProperty(position=2, required=true, example="193.0.0.0/21")
    @NotNull
    @ValidPrefix
    String prefix;
    @ApiModelProperty(position=3, value="Maxlength (>= prefix size)")
    @Min(value=0L)
    @Max(value=128L)
    @Min(value=0L) @Max(value=128L) Integer maximumLength;
    @ApiModelProperty(position=4)
    @Size(max=2000)
    @Size(max=2000) String comment;

    @ConstructorProperties(value={"asn", "prefix", "maximumLength", "comment"})
    AddRoaPrefixAssertion(String asn, String prefix, Integer maximumLength, String comment) {
        this.asn = asn;
        this.prefix = prefix;
        this.maximumLength = maximumLength;
        this.comment = comment;
    }

    public static AddRoaPrefixAssertionBuilder builder() {
        return new AddRoaPrefixAssertionBuilder();
    }

    private AddRoaPrefixAssertion() {
    }

    public String getAsn() {
        return this.asn;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Integer getMaximumLength() {
        return this.maximumLength;
    }

    public String getComment() {
        return this.comment;
    }

    public void setAsn(String asn) {
        this.asn = asn;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setMaximumLength(Integer maximumLength) {
        this.maximumLength = maximumLength;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddRoaPrefixAssertion)) {
            return false;
        }
        AddRoaPrefixAssertion other = (AddRoaPrefixAssertion)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$asn = this.getAsn();
        String other$asn = other.getAsn();
        if (this$asn == null ? other$asn != null : !this$asn.equals(other$asn)) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        Integer this$maximumLength = this.getMaximumLength();
        Integer other$maximumLength = other.getMaximumLength();
        if (this$maximumLength == null ? other$maximumLength != null : !((Object)this$maximumLength).equals(other$maximumLength)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        return !(this$comment == null ? other$comment != null : !this$comment.equals(other$comment));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AddRoaPrefixAssertion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $asn = this.getAsn();
        result = result * 59 + ($asn == null ? 43 : $asn.hashCode());
        String $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        Integer $maximumLength = this.getMaximumLength();
        result = result * 59 + ($maximumLength == null ? 43 : ((Object)$maximumLength).hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        return result;
    }

    public String toString() {
        return "AddRoaPrefixAssertion(asn=" + this.getAsn() + ", prefix=" + this.getPrefix() + ", maximumLength=" + this.getMaximumLength() + ", comment=" + this.getComment() + ")";
    }
}

