/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.domain.validation;

import com.google.common.base.Objects;
import java.net.URI;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCms;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.util.RepositoryObjectType;
import net.ripe.rpki.commons.validation.ValidationLocation;
import net.ripe.rpki.commons.validation.ValidationOptions;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.validation.ValidationStatus;
import net.ripe.rpki.commons.validation.objectvalidators.CertificateRepositoryObjectValidationContext;
import net.ripe.rpki.validator3.background.ValidationScheduler;
import net.ripe.rpki.validator3.domain.validation.TrustAnchorState;
import net.ripe.rpki.validator3.domain.validation.ValidatedRpkiObjects;
import net.ripe.rpki.validator3.storage.Storage;
import net.ripe.rpki.validator3.storage.Tx;
import net.ripe.rpki.validator3.storage.data.Key;
import net.ripe.rpki.validator3.storage.data.Ref;
import net.ripe.rpki.validator3.storage.data.RpkiObject;
import net.ripe.rpki.validator3.storage.data.RpkiRepository;
import net.ripe.rpki.validator3.storage.data.TrustAnchor;
import net.ripe.rpki.validator3.storage.data.validation.CertificateTreeValidationRun;
import net.ripe.rpki.validator3.storage.data.validation.ValidationRun;
import net.ripe.rpki.validator3.storage.stores.RpkiObjects;
import net.ripe.rpki.validator3.storage.stores.RpkiRepositories;
import net.ripe.rpki.validator3.storage.stores.Settings;
import net.ripe.rpki.validator3.storage.stores.TrustAnchors;
import net.ripe.rpki.validator3.storage.stores.ValidationRuns;
import net.ripe.rpki.validator3.util.Bench;
import net.ripe.rpki.validator3.util.Time;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CertificateTreeValidationService {
    private static final Logger log = LoggerFactory.getLogger(CertificateTreeValidationService.class);
    private static final ValidationOptions VALIDATION_OPTIONS = new ValidationOptions();
    private final RpkiObjects rpkiObjects;
    private final RpkiRepositories rpkiRepositories;
    private final Settings settings;
    private final ValidationScheduler validationScheduler;
    private final ValidationRuns validationRuns;
    private final TrustAnchors trustAnchors;
    private final Storage storage;
    private final ValidatedRpkiObjects validatedRpkiObjects;
    private final TrustAnchorState trustAnchorState;

    @Autowired
    public CertificateTreeValidationService(RpkiObjects rpkiObjects, RpkiRepositories rpkiRepositories, Settings settings, ValidationScheduler validationScheduler, ValidationRuns validationRuns, TrustAnchors trustAnchors, ValidatedRpkiObjects validatedRpkiObjects, Storage storage, TrustAnchorState trustAnchorState) {
        this.rpkiObjects = rpkiObjects;
        this.rpkiRepositories = rpkiRepositories;
        this.settings = settings;
        this.validationScheduler = validationScheduler;
        this.validationRuns = validationRuns;
        this.trustAnchors = trustAnchors;
        this.validatedRpkiObjects = validatedRpkiObjects;
        this.storage = storage;
        this.trustAnchorState = trustAnchorState;
    }

    public void validate(long trustAnchorId) {
        Optional maybeTrustAnchor = (Optional)this.storage.readTx(tx -> this.trustAnchors.get(tx, Key.of((long)trustAnchorId)));
        if (!maybeTrustAnchor.isPresent()) {
            log.error("Couldn't find trust anchor {}", (Object)trustAnchorId);
            return;
        }
        Bench.mark0((String)("validateTa " + ((TrustAnchor)maybeTrustAnchor.get()).getName()), () -> this.validateTa((TrustAnchor)maybeTrustAnchor.get()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateTa(TrustAnchor trustAnchor) {
        CertificateRepositoryObjectValidationContext context;
        X509ResourceCertificate trustAnchorCertificate;
        ValidationResult validationResult;
        CertificateTreeValidationRun validationRun;
        Ref trustAnchorRef;
        Map registeredRepositories;
        long begin;
        block9: {
            block8: {
                String trustAnchorLocation;
                block7: {
                    log.info("Starting tree validation for {}", (Object)trustAnchor);
                    begin = System.currentTimeMillis();
                    registeredRepositories = this.createRegisteredRepositoryMap(trustAnchor);
                    trustAnchorRef = (Ref)this.storage.readTx(tx -> this.trustAnchors.makeRef(tx, trustAnchor.key()));
                    validationRun = new CertificateTreeValidationRun(trustAnchorRef);
                    trustAnchorLocation = (String)trustAnchor.getLocations().get(0);
                    validationResult = ValidationResult.withLocation((String)trustAnchorLocation);
                    try {
                        trustAnchorCertificate = trustAnchor.getCertificate();
                        validationResult.rejectIfNull((Object)trustAnchorCertificate, "validator.trust.anchor.certificate.available", new String[0]);
                        if (trustAnchorCertificate != null) break block7;
                    }
                    catch (Throwable throwable) {
                        validationRun.completeWith(validationResult);
                        this.storage.writeTx0(tx -> this.validationRuns.update(tx, (ValidationRun)validationRun));
                        this.trustAnchorState.setValidatedAfterLastRepositoryUpdate(trustAnchor);
                        long end = System.currentTimeMillis();
                        log.info("Tree validation {} for {} in {}ms", new Object[]{validationRun.getStatus().toString().toLowerCase(), trustAnchor.getName(), end - begin});
                        throw throwable;
                    }
                    validationRun.completeWith(validationResult);
                    this.storage.writeTx0(tx -> this.validationRuns.update(tx, (ValidationRun)validationRun));
                    this.trustAnchorState.setValidatedAfterLastRepositoryUpdate(trustAnchor);
                    long end = System.currentTimeMillis();
                    log.info("Tree validation {} for {} in {}ms", new Object[]{validationRun.getStatus().toString().toLowerCase(), trustAnchor.getName(), end - begin});
                    return;
                }
                context = new CertificateRepositoryObjectValidationContext(URI.create(trustAnchorLocation), trustAnchorCertificate);
                trustAnchorCertificate.validate(trustAnchorLocation, context, null, null, VALIDATION_OPTIONS, validationResult);
                if (!validationResult.hasFailureForCurrentLocation()) break block8;
                validationRun.completeWith(validationResult);
                this.storage.writeTx0(tx -> this.validationRuns.update(tx, (ValidationRun)validationRun));
                this.trustAnchorState.setValidatedAfterLastRepositoryUpdate(trustAnchor);
                long end = System.currentTimeMillis();
                log.info("Tree validation {} for {} in {}ms", new Object[]{validationRun.getStatus().toString().toLowerCase(), trustAnchor.getName(), end - begin});
                return;
            }
            URI locationUri = (URI)Objects.firstNonNull((Object)trustAnchorCertificate.getRrdpNotifyUri(), (Object)trustAnchorCertificate.getRepositoryUri());
            validationResult.warnIfNull((Object)locationUri, "validator.trust.anchor.certificate.rrdp.notify.uri.or.repository.uri.present", new String[0]);
            if (locationUri != null) break block9;
            validationRun.completeWith(validationResult);
            this.storage.writeTx0(tx -> this.validationRuns.update(tx, (ValidationRun)validationRun));
            this.trustAnchorState.setValidatedAfterLastRepositoryUpdate(trustAnchor);
            long end = System.currentTimeMillis();
            log.info("Tree validation {} for {} in {}ms", new Object[]{validationRun.getStatus().toString().toLowerCase(), trustAnchor.getName(), end - begin});
            return;
        }
        List rpkiObjectsKeys = this.validateCertificateAuthority(trustAnchor, registeredRepositories, context, validationResult);
        if (rpkiObjectsKeys.isEmpty() && this.isValidationRunCompleted(validationResult)) {
            log.info("No associated objects, validation run: {}, validation result: {}", (Object)validationRun.key(), (Object)validationResult);
        }
        this.storage.writeTx0(tx -> {
            this.validationRuns.add(tx, (ValidationRun)validationRun);
            Long t = Time.timed(() -> rpkiObjectsKeys.forEach(key -> this.validationRuns.associateRpkiObjectKey(tx, validationRun, key)));
            log.info("Associated {} objects with the validation run {} in {}ms", new Object[]{rpkiObjectsKeys.size(), validationRun.key(), t});
            this.markTaObjectsReachable(tx, trustAnchorCertificate);
            Long tmr = Time.timed(() -> this.rpkiObjects.markReachable(tx, rpkiObjectsKeys));
            log.info("Marked {} objects as reachable in {}ms", (Object)rpkiObjectsKeys.size(), (Object)tmr);
            if (this.isValidationRunCompleted(validationResult)) {
                trustAnchor.markInitialCertificateTreeValidationRunCompleted();
                this.trustAnchors.update(tx, trustAnchor);
                if (!this.settings.isInitialValidationRunCompleted((Tx.Read)tx) && this.trustAnchors.allInitialCertificateTreeValidationRunsCompleted((Tx.Read)tx)) {
                    this.settings.markInitialValidationRunCompleted(tx);
                    log.info("All trust anchors have completed their initial certificate tree validation run, validator is now ready");
                }
            }
        });
        if (!rpkiObjectsKeys.isEmpty()) {
            this.storage.readTx0(tx -> this.validatedRpkiObjects.updateByKey(tx, trustAnchorRef, (Collection)rpkiObjectsKeys));
        }
        validationRun.completeWith(validationResult);
        this.storage.writeTx0(tx -> this.validationRuns.update(tx, (ValidationRun)validationRun));
        this.trustAnchorState.setValidatedAfterLastRepositoryUpdate(trustAnchor);
        long end = System.currentTimeMillis();
        log.info("Tree validation {} for {} in {}ms", new Object[]{validationRun.getStatus().toString().toLowerCase(), trustAnchor.getName(), end - begin});
    }

    private void markTaObjectsReachable(Tx.Write tx, X509ResourceCertificate taCertificate) {
        Instant now = Instant.now();
        this.rpkiObjects.findLatestMftByAKI((Tx.Read)tx, taCertificate.getSubjectKeyIdentifier()).ifPresent(manifest -> {
            this.rpkiObjects.markReachable(tx, manifest.key(), now);
            manifest.get(ManifestCms.class, ValidationResult.withLocation((String)"ta-manifest.mft")).ifPresent(manifestCms -> this.rpkiObjects.findObjectsInManifest((Tx.Read)tx, manifestCms).forEach((entry, rpkiObject) -> this.rpkiObjects.markReachable(tx, rpkiObject.key(), now)));
        });
    }

    private boolean isValidationRunCompleted(ValidationResult validationResult) {
        return validationResult.getWarnings().stream().noneMatch(check -> check.getStatus() != ValidationStatus.PASSED && "validator.rpki.repository.pending".equals(check.getKey()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Key> validateCertificateAuthority(TrustAnchor trustAnchor, Map<URI, RpkiRepository> registeredRepositories, CertificateRepositoryObjectValidationContext context, ValidationResult validationResult) {
        ArrayList<Key> validatedObjects = new ArrayList<Key>();
        ValidationLocation certificateLocation = validationResult.getCurrentLocation();
        ValidationResult temporary = ValidationResult.withLocation((ValidationLocation)certificateLocation);
        try {
            RpkiRepository rpkiRepository = (RpkiRepository)Bench.mark((String)trustAnchor.getName(), (String)"registerRepository", () -> (RpkiRepository)this.storage.writeTx(tx -> this.registerRepository(tx, trustAnchor, registeredRepositories, context)));
            temporary.warnIfTrue(rpkiRepository.isPending(), "validator.rpki.repository.pending", new String[]{rpkiRepository.getLocationUri()});
            if (rpkiRepository.isPending()) {
                ArrayList<Key> arrayList = validatedObjects;
                return arrayList;
            }
            X509ResourceCertificate certificate = context.getCertificate();
            URI manifestUri = certificate.getManifestUri();
            temporary.setLocation(new ValidationLocation(manifestUri));
            Optional manifestObject = (Optional)Bench.mark((String)trustAnchor.getName(), (String)"findLatestMftByAKI", () -> (Optional)this.storage.readTx(tx -> this.rpkiObjects.findLatestMftByAKI(tx, certificate.getSubjectKeyIdentifier())));
            if (!manifestObject.isPresent()) {
                if (rpkiRepository.getStatus() == RpkiRepository.Status.FAILED) {
                    temporary.error("validator.no.manifest.repository.failed", new String[]{rpkiRepository.getLocationUri()});
                } else {
                    temporary.error("validator.no.local.manifest.no.manifest.in.repository", new String[]{rpkiRepository.getLocationUri()});
                }
            }
            Optional maybeManifest = manifestObject.flatMap(x -> x.get(ManifestCms.class, temporary));
            temporary.rejectIfTrue(manifestObject.isPresent() && rpkiRepository.getStatus() == RpkiRepository.Status.FAILED && maybeManifest.isPresent() && ((ManifestCms)maybeManifest.get()).isPastValidityTime(), "validator.old.local.manifest.repository.failed", new String[]{rpkiRepository.getLocationUri()});
            if (temporary.hasFailureForCurrentLocation()) {
                ArrayList<Key> arrayList = validatedObjects;
                return arrayList;
            }
            ManifestCms manifest = (ManifestCms)maybeManifest.get();
            List crlEntries = manifest.getFiles().entrySet().stream().filter(entry -> RepositoryObjectType.parse((String)((String)entry.getKey())) == RepositoryObjectType.Crl).collect(Collectors.toList());
            temporary.rejectIfFalse(crlEntries.size() == 1, "validator.manifest.contains.one.crl.entry", new String[]{String.valueOf(crlEntries.size())});
            if (temporary.hasFailureForCurrentLocation()) {
                ArrayList<Key> arrayList = validatedObjects;
                return arrayList;
            }
            Map.Entry crlEntry = (Map.Entry)crlEntries.get(0);
            URI crlUri = manifestUri.resolve((String)crlEntry.getKey());
            Optional crlObject = (Optional)this.storage.readTx(tx -> this.rpkiObjects.findBySha256(tx, (byte[])crlEntry.getValue()));
            temporary.rejectIfFalse(crlObject.isPresent(), "validator.crl.found", new String[]{crlUri.toASCIIString()});
            if (temporary.hasFailureForCurrentLocation()) {
                ArrayList<Key> arrayList = validatedObjects;
                return arrayList;
            }
            temporary.setLocation(new ValidationLocation(crlUri));
            Optional crl = crlObject.flatMap(x -> x.get(X509Crl.class, temporary));
            if (temporary.hasFailureForCurrentLocation()) {
                ArrayList<Key> arrayList = validatedObjects;
                return arrayList;
            }
            ((X509Crl)crl.get()).validate(crlUri.toASCIIString(), context, null, VALIDATION_OPTIONS, temporary);
            if (temporary.hasFailureForCurrentLocation()) {
                ArrayList<Key> arrayList = validatedObjects;
                return arrayList;
            }
            temporary.setLocation(new ValidationLocation(manifestUri));
            manifest.validate(manifestUri.toASCIIString(), context, (X509Crl)crl.get(), manifest.getCrlUri(), VALIDATION_OPTIONS, temporary);
            if (temporary.hasFailureForCurrentLocation()) {
                ArrayList<Key> arrayList = validatedObjects;
                return arrayList;
            }
            validatedObjects.add(((RpkiObject)manifestObject.get()).key());
            ((Map)Bench.mark((String)trustAnchor.getName(), (String)"retrieveManifestEntries", () -> (Map)this.storage.readTx(tx -> this.retrieveManifestEntries(tx, manifest, manifestUri, temporary)))).entrySet().stream().map(e -> {
                URI location = (URI)e.getKey();
                RpkiObject rpkiObject = (RpkiObject)e.getValue();
                temporary.setLocation(new ValidationLocation(location));
                Optional maybeCertificateRepositoryObject = (Optional)Bench.mark((String)trustAnchor.getName(), (String)"rpkiObject.get", () -> rpkiObject.get(CertificateRepositoryObject.class, temporary));
                if (!temporary.hasFailureForCurrentLocation()) {
                    return maybeCertificateRepositoryObject.flatMap(certificateRepositoryObject -> {
                        Bench.mark0((String)trustAnchor.getName(), (String)"certificateRepositoryObject.validate", () -> certificateRepositoryObject.validate(location.toASCIIString(), context, (X509Crl)crl.get(), crlUri, VALIDATION_OPTIONS, temporary));
                        if (!temporary.hasFailureForCurrentLocation()) {
                            validatedObjects.add(rpkiObject.key());
                        }
                        if (certificateRepositoryObject instanceof X509ResourceCertificate && ((X509ResourceCertificate)certificateRepositoryObject).isCa() && !temporary.hasFailureForCurrentLocation()) {
                            return Optional.of(context.createChildContext(location, (X509ResourceCertificate)certificateRepositoryObject));
                        }
                        return Optional.empty();
                    });
                }
                return Optional.empty();
            }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()).parallelStream().map(childContext -> this.validateCertificateAuthority(trustAnchor, registeredRepositories, childContext, temporary)).forEachOrdered(validatedObjects::addAll);
        }
        catch (Exception e2) {
            CertificateTreeValidationService certificateTreeValidationService = this;
            synchronized (certificateTreeValidationService) {
                validationResult.error("unhandled.exception", new String[]{e2.toString(), ExceptionUtils.getStackTrace((Throwable)e2)});
            }
        }
        finally {
            CertificateTreeValidationService certificateTreeValidationService = this;
            synchronized (certificateTreeValidationService) {
                validationResult.addAll(temporary);
            }
        }
        return validatedObjects;
    }

    private RpkiRepository registerRepository(Tx.Write tx, TrustAnchor trustAnchor, Map<URI, RpkiRepository> registeredRepositories, CertificateRepositoryObjectValidationContext context) {
        if (context.getRpkiNotifyURI() != null) {
            return registeredRepositories.computeIfAbsent(context.getRpkiNotifyURI(), uri -> {
                Ref trustAnchorRef = this.trustAnchors.makeRef((Tx.Read)tx, trustAnchor.key());
                RpkiRepository r = this.rpkiRepositories.register(tx, trustAnchorRef, uri.toASCIIString(), RpkiRepository.Type.RRDP);
                tx.afterCommit(() -> this.validationScheduler.addRrdpRpkiRepository(r));
                return r;
            });
        }
        return registeredRepositories.computeIfAbsent(context.getRepositoryURI(), uri -> {
            Ref trustAnchorRef = this.trustAnchors.makeRef((Tx.Read)tx, trustAnchor.key());
            return this.rpkiRepositories.register(tx, trustAnchorRef, uri.toASCIIString(), RpkiRepository.Type.RSYNC);
        });
    }

    private Map<URI, RpkiRepository> createRegisteredRepositoryMap(TrustAnchor trustAnchor) {
        ConcurrentHashMap<URI, RpkiRepository> registeredRepositories = new ConcurrentHashMap<URI, RpkiRepository>();
        long t = Time.timed(() -> ((Collection)this.storage.readTx(tx -> this.rpkiRepositories.findByTrustAnchor(tx, trustAnchor.key()))).forEach(r -> {
            if (r.getRrdpNotifyUri() != null) {
                registeredRepositories.put(URI.create(r.getRrdpNotifyUri()), (RpkiRepository)r);
            } else {
                registeredRepositories.put(URI.create(r.getLocationUri()), (RpkiRepository)r);
            }
        }));
        log.info("Pre-loaded {} repositories in {}ms", (Object)registeredRepositories.size(), (Object)t);
        return registeredRepositories;
    }

    private Map<URI, RpkiObject> retrieveManifestEntries(Tx.Read tx, ManifestCms manifest, URI manifestUri, ValidationResult validationResult) {
        LinkedHashMap<URI, RpkiObject> result = new LinkedHashMap<URI, RpkiObject>();
        for (Map.Entry entry : manifest.getFiles().entrySet()) {
            URI location = manifestUri.resolve((String)entry.getKey());
            validationResult.setLocation(new ValidationLocation(location));
            Optional object = this.rpkiObjects.findBySha256(tx, (byte[])entry.getValue());
            validationResult.rejectIfFalse(object.isPresent(), "validator.manifest.entry.found", new String[]{manifestUri.toASCIIString()});
            object.ifPresent(obj -> {
                boolean hashMatches = Arrays.equals(obj.getSha256(), (byte[])entry.getValue());
                validationResult.rejectIfFalse(hashMatches, "validator.manifest.entry.hash.matches", new String[]{(String)entry.getKey()});
                if (hashMatches) {
                    result.put(location, (RpkiObject)obj);
                }
            });
        }
        return result;
    }
}

