/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.api.slurm;

import com.google.common.base.Charsets;
import java.util.Locale;
import net.ripe.rpki.validator3.api.ApiError;
import net.ripe.rpki.validator3.api.ApiResponse;
import net.ripe.rpki.validator3.api.slurm.SlurmService;
import net.ripe.rpki.validator3.api.slurm.dtos.Slurm;
import net.ripe.rpki.validator3.api.trustanchors.TrustAnchorResource;
import net.ripe.rpki.validator3.storage.encoding.GsonCoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@RestController
@RequestMapping(path={"/api/slurm"}, produces={"application/vnd.net.ripe.rpki.validator.v3+json; charset=UTF-8", "application/json"})
public class SlurmController {
    private static final Logger log = LoggerFactory.getLogger(SlurmController.class);
    @Autowired
    private SlurmService slurmService;

    @PostMapping(path={"/upload"}, consumes={"multipart/form-data"})
    public ResponseEntity<ApiResponse<TrustAnchorResource>> add(@RequestParam(value="file") MultipartFile trustAnchorLocator, Locale locale) {
        try {
            String contents = new String(trustAnchorLocator.getBytes(), Charsets.UTF_8);
            this.slurmService.process((Slurm)GsonCoder.getPrettyGson().fromJson(contents, Slurm.class));
            return ResponseEntity.noContent().build();
        }
        catch (Exception ex) {
            return ResponseEntity.badRequest().body((Object)ApiResponse.error((ApiError[])new ApiError[]{ApiError.of((HttpStatus)HttpStatus.BAD_REQUEST, (String)("Invalid SLURM file: " + ex.getMessage()))}));
        }
    }

    @GetMapping
    public ResponseEntity<String> slurm() {
        return ResponseEntity.ok((Object)GsonCoder.getGson().toJson((Object)this.slurmService.get()));
    }

    @GetMapping(path={"/download"}, produces={"application/vnd.net.ripe.rpki.validator.v3+json; charset=UTF-8"})
    public StreamingResponseBody download() {
        return out -> this.slurmService.writeTo(out);
    }
}

