/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.api.roas;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.ripe.rpki.validator3.api.ApiResponse;
import net.ripe.rpki.validator3.api.bgpsec.BgpSecAssertionsService;
import net.ripe.rpki.validator3.api.bgpsec.BgpSecFilterService;
import net.ripe.rpki.validator3.api.ignorefilters.IgnoreFilterService;
import net.ripe.rpki.validator3.api.roaprefixassertions.RoaPrefixAssertionsService;
import net.ripe.rpki.validator3.api.roas.ObjectController;
import net.ripe.rpki.validator3.api.trustanchors.TrustAnchorResource;
import net.ripe.rpki.validator3.domain.IgnoreFiltersPredicate;
import net.ripe.rpki.validator3.domain.validation.TrustAnchorState;
import net.ripe.rpki.validator3.domain.validation.ValidatedRpkiObjects;
import net.ripe.rpki.validator3.storage.Storage;
import net.ripe.rpki.validator3.storage.data.RpkiRepository;
import net.ripe.rpki.validator3.storage.data.TrustAnchor;
import net.ripe.rpki.validator3.storage.stores.RpkiRepositories;
import net.ripe.rpki.validator3.storage.stores.TrustAnchors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api/objects"}, produces={"application/vnd.net.ripe.rpki.validator.v3+json; charset=UTF-8", "application/json"})
public class ObjectController {
    private static final Logger log = LoggerFactory.getLogger(ObjectController.class);
    @Autowired
    private ValidatedRpkiObjects validatedRpkiObjects;
    @Autowired
    private TrustAnchors trustAnchors;
    @Autowired
    private RpkiRepositories rpkiRepositories;
    @Autowired
    private IgnoreFilterService ignoreFilters;
    @Autowired
    private RoaPrefixAssertionsService roaPrefixAssertions;
    @Autowired
    private BgpSecAssertionsService bgpSecAssertions;
    @Autowired
    private BgpSecFilterService bgpSecFilterService;
    @Autowired
    private TrustAnchorState trustAnchorState;
    @Autowired
    private Storage storage;

    @GetMapping(path={"/validated"})
    public ResponseEntity<ApiResponse<ValidatedObjects>> list(Locale locale) {
        List trustAnchorList = (List)this.storage.readTx(tx -> this.trustAnchors.findAll(tx));
        Stream<RoaPrefix> validatedPrefixes = this.validatedRpkiObjects.findCurrentlyValidatedRoaPrefixes(null, null, null).getObjects().filter(new IgnoreFiltersPredicate(this.ignoreFilters.all()).negate()).map(prefix -> new RoaPrefix(String.valueOf(prefix.getAsn()), prefix.getPrefix().toString(), prefix.getEffectiveLength()));
        Stream<RoaPrefix> assertions = this.roaPrefixAssertions.all().map(assertion -> new RoaPrefix(assertion.getAsn().toString(), assertion.getPrefix().toString(), assertion.getMaxPrefixLength() != null ? assertion.getMaxPrefixLength().intValue() : assertion.getPrefix().getPrefixLength()));
        Stream<RoaPrefix> combinedPrefixes = Stream.concat(validatedPrefixes, assertions).distinct();
        Stream certificates = this.validatedRpkiObjects.findCurrentlyValidatedRouterCertificates().getObjects();
        Stream<RouterCertificate> filteredRouterCertificates = this.bgpSecFilterService.filterCertificates(certificates).map(o -> new RouterCertificate((List)o.getAsn(), o.getSubjectKeyIdentifier(), o.getSubjectPublicKeyInfo()));
        Stream<RouterCertificate> bgpSecAssertions = this.bgpSecAssertions.all().map(b -> {
            List<String> asns = Collections.singletonList(String.valueOf(b.getAsn()));
            return new RouterCertificate(asns, b.getSki(), b.getPublicKey());
        });
        Stream<RouterCertificate> combinedAssertions = Stream.concat(filteredRouterCertificates, bgpSecAssertions).distinct();
        boolean noPendingRepositories = (Boolean)this.storage.readTx(tx -> trustAnchorList.stream().allMatch(ta -> {
            Map statusLongMap = this.rpkiRepositories.countByStatus(tx, ta.key(), true);
            Long pendingRepoNumber = (Long)statusLongMap.get(RpkiRepository.Status.PENDING);
            return pendingRepoNumber == null || pendingRepoNumber == 0L;
        }));
        boolean allTasDoneInitialLoading = (Boolean)this.storage.readTx(tx -> this.trustAnchors.allInitialCertificateTreeValidationRunsCompleted(tx));
        List trustAnchorResources = trustAnchorList.stream().map(ta -> TrustAnchorResource.of((TrustAnchor)ta, (Locale)Locale.ROOT)).collect(Collectors.toList());
        return ResponseEntity.ok((Object)ApiResponse.builder().data((Object)new ValidatedObjects(allTasDoneInitialLoading && noPendingRepositories && this.trustAnchorState.allTAsValidatedAfterRepositoryLoading(), trustAnchorResources, combinedPrefixes, combinedAssertions)).build());
    }
}

