/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.api.ignorefilters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.Valid;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpRange;
import net.ripe.ipresource.IpResource;
import net.ripe.rpki.validator3.api.Paging;
import net.ripe.rpki.validator3.api.SearchTerm;
import net.ripe.rpki.validator3.api.Sorting;
import net.ripe.rpki.validator3.api.ignorefilters.AddIgnoreFilter;
import net.ripe.rpki.validator3.api.ignorefilters.IgnoreFilter;
import net.ripe.rpki.validator3.api.ignorefilters.IgnoreFilterService;
import net.ripe.rpki.validator3.api.slurm.SlurmStore;
import net.ripe.rpki.validator3.api.slurm.dtos.Slurm;
import net.ripe.rpki.validator3.api.slurm.dtos.SlurmExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

@Component
@Validated
public class IgnoreFilterService {
    private static final Logger log = LoggerFactory.getLogger(IgnoreFilterService.class);
    private final Object listenersLock = new Object();
    private final List<Consumer<Collection<IgnoreFilter>>> listeners = new ArrayList();
    private final SlurmStore slurmStore;

    @Autowired
    public IgnoreFilterService(SlurmStore slurmStore) {
        this.slurmStore = slurmStore;
    }

    public long execute(@Valid AddIgnoreFilter command) {
        return (Long)this.slurmStore.updateWith(slurmExt -> {
            Slurm.SlurmPrefixFilter ignoreFilter = new Slurm.SlurmPrefixFilter();
            ignoreFilter.setAsn(Long.valueOf(Asn.parse((String)command.getAsn()).longValue()));
            ignoreFilter.setPrefix(IpRange.parse((String)command.getPrefix()));
            ignoreFilter.setComment(command.getComment());
            long id = this.slurmStore.nextId();
            slurmExt.getPrefixFilters().put(id, ignoreFilter);
            log.info("added ignore filter '{}'", (Object)ignoreFilter);
            return id;
        });
    }

    public void remove(long ignoreFilterId) {
        Boolean notify = (Boolean)this.slurmStore.updateWith(slurmExt -> slurmExt.getPrefixFilters().remove(ignoreFilterId) != null);
        if (notify.booleanValue()) {
            this.notifyListeners();
        }
    }

    public void clear() {
        this.slurmStore.updateWith(IgnoreFilterService::clearAll);
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Consumer<Collection<IgnoreFilter>> listener) {
        Object object = this.listenersLock;
        synchronized (object) {
            List filters = this.all().collect(Collectors.toList());
            listener.accept(filters);
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners() {
        Object object = this.listenersLock;
        synchronized (object) {
            List filters = this.all().collect(Collectors.toList());
            this.listeners.forEach(listener -> listener.accept(filters));
        }
    }

    public Stream<IgnoreFilter> all() {
        return this.slurmStore.read().getPrefixFilters().entrySet().stream().map(e -> this.makeIgnoreFilter((Long)e.getKey(), (Slurm.SlurmPrefixFilter)e.getValue()));
    }

    public Stream<IgnoreFilter> find(SearchTerm searchTerm, Sorting sorting, Paging paging) {
        Stream all = this.slurmStore.read().getPrefixFilters().entrySet().stream();
        all = this.applySearch(searchTerm, all).sorted(this.toOrderSpecifier(sorting));
        if (paging != null) {
            all = paging.apply(all);
        }
        return all.map(e -> this.makeIgnoreFilter((Long)e.getKey(), (Slurm.SlurmPrefixFilter)e.getValue()));
    }

    private IgnoreFilter makeIgnoreFilter(Long id, Slurm.SlurmPrefixFilter value) {
        return new IgnoreFilter(id.longValue(), value.getAsn(), value.getPrefix(), value.getComment());
    }

    public Stream<Map.Entry<Long, Slurm.SlurmPrefixFilter>> applySearch(SearchTerm searchTerm, Stream<Map.Entry<Long, Slurm.SlurmPrefixFilter>> all) {
        if (searchTerm != null) {
            all = searchTerm.asAsn() != null ? all.filter(pf -> ((Slurm.SlurmPrefixFilter)pf.getValue()).getAsn().longValue() == searchTerm.asAsn().longValue()) : (searchTerm.asIpRange() != null ? all.filter(pf -> ((Slurm.SlurmPrefixFilter)pf.getValue()).getPrefix().overlaps((IpResource)searchTerm.asIpRange())) : all.filter(pf -> ((Slurm.SlurmPrefixFilter)pf.getValue()).getComment().toLowerCase().contains(searchTerm.asString().toLowerCase())));
        }
        return all;
    }

    public long count(SearchTerm searchTerm) {
        return this.applySearch(searchTerm, this.slurmStore.read().getPrefixFilters().entrySet().stream()).count();
    }

    public IgnoreFilter get(long id) {
        Slurm.SlurmPrefixFilter slurmPrefixFilter = (Slurm.SlurmPrefixFilter)this.slurmStore.read().getPrefixFilters().get(id);
        if (slurmPrefixFilter == null) {
            return null;
        }
        return this.makeIgnoreFilter(Long.valueOf(id), slurmPrefixFilter);
    }

    private Comparator<Map.Entry<Long, Slurm.SlurmPrefixFilter>> toOrderSpecifier(Sorting sorting) {
        Comparator<Map.Entry<Long, Slurm.SlurmPrefixFilter>> comparator;
        if (sorting == null) {
            sorting = Sorting.of((Sorting.By)Sorting.By.ASN, (Sorting.Direction)Sorting.Direction.ASC);
        }
        switch (1.$SwitchMap$net$ripe$rpki$validator3$api$Sorting$By[sorting.getBy().ordinal()]) {
            case 1: {
                comparator = Comparator.comparing(e -> ((Slurm.SlurmPrefixFilter)e.getValue()).getPrefix());
                break;
            }
            case 2: {
                comparator = Comparator.comparing(e -> ((Slurm.SlurmPrefixFilter)e.getValue()).getComment());
                break;
            }
            default: {
                comparator = Comparator.comparing(e -> ((Slurm.SlurmPrefixFilter)e.getValue()).getAsn());
            }
        }
        return sorting.getDirection() == Sorting.Direction.DESC ? comparator.reversed() : comparator;
    }

    private static void clearAll(SlurmExt slurmExt) {
        slurmExt.getPrefixFilters().clear();
    }
}

