/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.storage.encoding.custom;

import com.google.common.primitives.Longs;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Coders {
    public static byte[] toBytes(String s) {
        return s.getBytes(StandardCharsets.UTF_8);
    }

    public static byte[] toBytes(Instant instant) {
        return Longs.toByteArray((long)instant.toEpochMilli());
    }

    public static byte[] toBytes(int i) {
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.putInt(i);
        return bb.array();
    }

    public static byte[] toBytes(short i) {
        ByteBuffer bb = ByteBuffer.allocate(2);
        bb.putShort(i);
        return bb.array();
    }

    public static byte[] toBytes(long long_) {
        return Longs.toByteArray((long)long_);
    }

    public static byte[] toBytes(BigInteger bi) {
        return bi.toByteArray();
    }

    public static <R> byte[] toBytes(Collection<R> list, Function<R, byte[]> f) {
        List<byte[]> bs = list.stream().map(f).collect(Collectors.toList());
        int fullSize = 4 + bs.stream().map(b -> ((byte[])b).length + 4).reduce(0, Integer::sum);
        byte[] array = new byte[fullSize];
        ByteBuffer bb = ByteBuffer.wrap(array);
        bb.putInt(bs.size());
        bs.forEach(b -> {
            bb.putInt(((byte[])b).length);
            bb.put((byte[])b);
        });
        return array;
    }

    public static <R> List<R> fromBytes(byte[] array, Function<byte[], R> c) {
        ByteBuffer bb = ByteBuffer.wrap(array);
        int fullSize = bb.getInt();
        ArrayList<R> list = new ArrayList<R>(fullSize);
        for (int i = 0; i < fullSize; ++i) {
            int size = bb.getInt();
            byte[] bytes = new byte[size];
            bb.get(bytes);
            list.add(c.apply(bytes));
        }
        return list;
    }

    public static long toLong(byte[] bytes) {
        return Longs.fromByteArray((byte[])bytes);
    }

    public static int toInt(byte[] bytes) {
        return ByteBuffer.wrap(bytes).getInt();
    }

    public static short toShort(byte[] bytes) {
        return ByteBuffer.wrap(bytes).getShort();
    }

    public static Instant toInstant(byte[] bytes) {
        return Instant.ofEpochMilli(Longs.fromByteArray((byte[])bytes));
    }

    public static String toString(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static BigInteger toBigInteger(byte[] b) {
        return new BigInteger(b);
    }

    public static byte[] toBytes(Boolean b) {
        byte[] bytes = new byte[]{(byte)(b != false ? 1 : 0)};
        return bytes;
    }

    public static boolean toBoolean(byte[] b) {
        return b[0] == 1;
    }
}

