/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.api.bgp;

import java.util.function.Supplier;
import java.util.stream.Stream;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpRange;
import net.ripe.rpki.validator3.api.ApiResponse;
import net.ripe.rpki.validator3.api.Metadata;
import net.ripe.rpki.validator3.api.Paging;
import net.ripe.rpki.validator3.api.SearchTerm;
import net.ripe.rpki.validator3.api.Sorting;
import net.ripe.rpki.validator3.api.bgp.BgpPreviewController;
import net.ripe.rpki.validator3.api.bgp.BgpPreviewService;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(path={"/api/bgp"}, produces={"application/vnd.net.ripe.rpki.validator.v3+json; charset=UTF-8", "application/json"})
public class BgpPreviewController {
    private static final Logger log = LoggerFactory.getLogger(BgpPreviewController.class);
    @Autowired
    private BgpPreviewService bgpPreviewService;

    @GetMapping(path={"/"})
    public ResponseEntity<ApiResponse<Stream<BgpPreview>>> list(@RequestParam(name="startFrom", defaultValue="0") long startFrom, @RequestParam(name="pageSize", defaultValue="20") long pageSize, @RequestParam(name="search", defaultValue="", required=false) String searchString, @RequestParam(name="sortBy", defaultValue="prefix") String sortBy, @RequestParam(name="sortDirection", defaultValue="asc") String sortDirection) {
        SearchTerm searchTerm = StringUtils.isNotBlank((String)searchString) ? new SearchTerm(searchString) : null;
        Sorting sorting = Sorting.parse((String)sortBy, (String)sortDirection);
        Paging paging = Paging.of((Long)startFrom, (Long)pageSize);
        BgpPreviewService.BgpPreviewResult bgpPreviewResult = this.bgpPreviewService.find(searchTerm, sorting, paging);
        return ResponseEntity.ok((Object)ApiResponse.builder().data(bgpPreviewResult.getData().map(entry -> BgpPreview.of((String)entry.getOrigin().toString(), (String)entry.getPrefix().toString(), (String)entry.getValidity().name()))).metadata(Metadata.of((long)bgpPreviewResult.getTotalCount(), (long)bgpPreviewResult.getLastModified())).build());
    }

    @GetMapping(path={"/validity"})
    public ResponseEntity<ApiResponse<BgpPreviewService.BgpValidityWithFilteredResource>> validity(@RequestParam(name="prefix") String prefix, @RequestParam(name="asn") String asn) {
        BgpPreviewService.BgpValidityWithFilteredResource bgp = this.bgpPreviewService.validity((Asn)BgpPreviewController.arg(() -> Asn.parse((String)asn)), (IpRange)BgpPreviewController.arg(() -> IpRange.parse((String)prefix)));
        return ResponseEntity.ok((Object)ApiResponse.builder().data((Object)bgp).metadata(Metadata.of((long)bgp.getValidatingRoas().size())).build());
    }

    private static <T> T arg(Supplier<T> s) {
        try {
            return s.get();
        }
        catch (Exception e) {
            throw new HttpMessageNotReadableException(e.getMessage());
        }
    }
}

