/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.ripe.rpki.validator3.util.HappyEyeballsResolver;
import net.ripe.rpki.validator3.util.Http;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpProxy;
import org.eclipse.jetty.client.ProxyConfiguration;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.util.InputStreamResponseListener;
import org.eclipse.jetty.util.SocketAddressResolver;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class Http {
    private static final Logger log = LoggerFactory.getLogger(Http.class);
    @Value(value="${rpki.validator.rrdp.trust.all.tls.certificates}")
    private boolean trustAllTlsCertificates;
    @Value(value="${rpki.validator.http.proxy.host:#{null}}")
    private String proxyHost;
    @Value(value="${rpki.validator.http.proxy.port:#{null}}")
    private Integer proxyPort;

    public HttpClient client() {
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setTrustAll(this.trustAllTlsCertificates);
        HttpClient httpClient = new HttpClient(sslContextFactory);
        log.info("Trust all TLS certificates: {}, proxy host is {}, proxy port is {}", new Object[]{this.trustAllTlsCertificates, this.proxyHost, this.proxyPort});
        if (this.proxyHost != null && this.proxyPort != null) {
            ProxyConfiguration proxyConfig = httpClient.getProxyConfiguration();
            HttpProxy proxy = new HttpProxy(this.proxyHost, this.proxyPort.intValue());
            proxyConfig.getProxies().add(proxy);
        }
        httpClient.setSocketAddressResolver((SocketAddressResolver)new HappyEyeballsResolver(httpClient));
        return httpClient;
    }

    public static <T> T readStream(Supplier<Request> requestF, Function<InputStream, T> reader) {
        BiFunction<InputStream, Long, Object> ignoreLastModified = (stream, ignoredLastModified) -> reader.apply((InputStream)stream);
        return (T)Http.readStream(requestF, ignoreLastModified);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T readStream(Supplier<Request> requestF, BiFunction<InputStream, Long, T> reader) {
        InputStreamResponseListener listener = new InputStreamResponseListener();
        Request request = requestF.get();
        request.header("User-Agent", "RIPE NCC RPKI Validator version 3");
        request.send((Response.CompleteListener)listener);
        Response response = null;
        try {
            response = listener.get(30L, TimeUnit.SECONDS);
            if (response.getStatus() != 200) {
                if (response.getStatus() == 304) {
                    NotModified error = new NotModified();
                    response.abort((Throwable)error);
                    throw error;
                }
                Failure error = new Failure("unexpected response status " + response.getStatus() + " for " + request.getURI());
                response.abort((Throwable)error);
                throw error;
            }
            long lastModified = response.getHeaders().getDateField("Last-Modified");
            try (InputStream inputStream = listener.getInputStream();){
                InputStream inputStream2 = reader.apply(inputStream, lastModified);
                return (T)inputStream2;
            }
        }
        catch (IOException | InterruptedException | ExecutionException | TimeoutException e) {
            Failure error = new Failure("failed reading response stream for " + request.getURI() + ": " + e, e);
            if (response == null) throw error;
            response.abort((Throwable)error);
            throw error;
        }
    }
}

