/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.storage.stores.impl;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.net.URI;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;
import net.ripe.rpki.validator3.api.Paging;
import net.ripe.rpki.validator3.api.SearchTerm;
import net.ripe.rpki.validator3.api.Sorting;
import net.ripe.rpki.validator3.background.ValidationScheduler;
import net.ripe.rpki.validator3.domain.constraints.ValidLocationURI;
import net.ripe.rpki.validator3.storage.IxMap;
import net.ripe.rpki.validator3.storage.Storage;
import net.ripe.rpki.validator3.storage.Tx;
import net.ripe.rpki.validator3.storage.data.Base;
import net.ripe.rpki.validator3.storage.data.Key;
import net.ripe.rpki.validator3.storage.data.Ref;
import net.ripe.rpki.validator3.storage.data.RpkiRepository;
import net.ripe.rpki.validator3.storage.data.TrustAnchor;
import net.ripe.rpki.validator3.storage.stores.GenericStoreImpl;
import net.ripe.rpki.validator3.storage.stores.RpkiRepositories;
import net.ripe.rpki.validator3.storage.stores.impl.RpkiRepositoriesStore;
import net.ripe.rpki.validator3.storage.stores.impl.SequencesStore;
import net.ripe.rpki.validator3.util.Rsync;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RpkiRepositoriesStore
extends GenericStoreImpl<RpkiRepository>
implements RpkiRepositories {
    private static final Logger log = LoggerFactory.getLogger(RpkiRepositoriesStore.class);
    private static final String RPKI_REPOSITORIES = "rpki-repositories";
    private static final String BY_URI_PREFIX = "by-uri";
    private static final String BY_TA = "by-ta";
    private final IxMap<RpkiRepository> ixMap;
    private final SequencesStore sequences;
    private final ValidationScheduler validationScheduler;

    @Autowired
    public RpkiRepositoriesStore(Storage storage, SequencesStore sequences, ValidationScheduler validationScheduler) {
        this.sequences = sequences;
        this.validationScheduler = validationScheduler;
        this.ixMap = storage.createIxMap(RPKI_REPOSITORIES, (Map)ImmutableMap.of((Object)BY_URI_PREFIX, arg_0 -> this.locationIndex(arg_0), (Object)BY_TA, r -> r.getTrustAnchors().stream().map(Ref::key).collect(Collectors.toSet())), RpkiRepository.class);
    }

    private Key uriToKey(String uri) {
        return Key.of((String)uri.substring(0, Math.min(uri.length(), 100)));
    }

    private Set<Key> locationIndex(RpkiRepository repository) {
        return Stream.of(repository.getRrdpNotifyUri(), repository.getRsyncRepositoryUri()).filter(Objects::nonNull).map(arg_0 -> this.uriToKey(arg_0)).collect(Collectors.toSet());
    }

    public RpkiRepository register(Tx.Write tx, Ref<TrustAnchor> trustAnchorRef, String uri, RpkiRepository.Type type) {
        RpkiRepository registered;
        Optional existing = this.findByURI((Tx.Read)tx, uri);
        if (existing.isPresent()) {
            registered = (RpkiRepository)existing.get();
            registered.addTrustAnchor(trustAnchorRef);
        } else {
            log.info("Registering new repository {} of type {}", (Object)uri, (Object)type);
            registered = new RpkiRepository(trustAnchorRef, uri, type);
            Key primaryKey = Key.of((long)this.sequences.next(tx, "rpki-repositories:pk"));
            registered.setId(primaryKey);
        }
        if (type == RpkiRepository.Type.RSYNC && registered.getType() == RpkiRepository.Type.RSYNC_PREFETCH) {
            registered.setType(RpkiRepository.Type.RSYNC);
        }
        if (registered.getType() == RpkiRepository.Type.RSYNC) {
            this.findRsyncParentRepository((Tx.Read)tx, uri).ifPresent(parent -> {
                registered.setParentRepository(Ref.of((Tx.Read)tx, (IxMap)this.ixMap, (Key)parent.key()));
                if (parent.isDownloaded()) {
                    registered.setDownloaded(parent.getLastDownloadedAt());
                }
            });
        }
        this.ixMap.put(tx, registered.key(), (Serializable)registered);
        return registered;
    }

    private Optional<RpkiRepository> findRsyncParentRepository(Tx.Read tx, @NotNull @ValidLocationURI String uri) {
        return Rsync.generateCandidateParentUris((URI)URI.create(uri)).stream().map(parentURI -> this.findByURI(tx, parentURI.toASCIIString())).filter(Optional::isPresent).findFirst().flatMap(Function.identity());
    }

    public void update(Tx.Write tx, RpkiRepository rpkiRepository) {
        rpkiRepository.setUpdatedAt(Instant.now());
        this.ixMap.put(tx, rpkiRepository.key(), (Serializable)rpkiRepository);
    }

    public Optional<RpkiRepository> findByURI(Tx.Read tx, String uri) {
        return this.ixMap.getByIndex(BY_URI_PREFIX, tx, this.uriToKey(uri)).values().stream().filter(r -> uri.equals(r.getRrdpNotifyUri()) || uri.equals(r.getRsyncRepositoryUri())).findFirst();
    }

    public Optional<RpkiRepository> get(Tx.Read tx, Key id) {
        return this.ixMap.get(tx, id);
    }

    public Stream<RpkiRepository> findAll(Tx.Read tx, RpkiRepository.Status optionalStatus, Key taId, boolean hideChildrenOfDownloadedParent, SearchTerm searchTerm, Sorting sorting, Paging paging) {
        return this.applyPaged(this.applySorting(this.applyFiltered(tx, optionalStatus, taId, hideChildrenOfDownloadedParent, searchTerm), sorting), paging);
    }

    private Stream<RpkiRepository> applyFiltered(Tx.Read tx, RpkiRepository.Status optionalStatus, Key taId, boolean hideChildrenOfDownloadedParent, SearchTerm searchTerm) {
        Stream<RpkiRepository> stream;
        Stream<Object> stream2 = stream = taId != null ? this.ixMap.getByIndex(BY_TA, tx, taId).values().stream() : this.ixMap.values(tx).stream();
        if (optionalStatus != null) {
            stream = stream.filter(r -> r.getStatus() == optionalStatus);
        }
        if (searchTerm != null) {
            String stringTerm = searchTerm.asString().toLowerCase();
            stream = stream.filter(r -> r.getLocationUri() != null && r.getLocationUri().toLowerCase().contains(stringTerm) || r.getStatus() != null && r.getStatus().toString().toLowerCase().contains(stringTerm));
        }
        if (hideChildrenOfDownloadedParent) {
            stream = stream.filter(r -> {
                Ref parentRef = r.getParentRepository();
                if (parentRef == null) {
                    return true;
                }
                Optional parent = this.ixMap.get(tx, parentRef.key());
                return !parent.isPresent() || ((RpkiRepository)parent.get()).getStatus() == RpkiRepository.Status.FAILED && ((RpkiRepository)parent.get()).getLastDownloadedAt() == null;
            });
        }
        return stream;
    }

    private Stream<RpkiRepository> applySorting(Stream<RpkiRepository> stream, Sorting sorting) {
        Comparator<RpkiRepository> comparator;
        if (sorting == null) {
            sorting = Sorting.of((Sorting.By)Sorting.By.LOCATION, (Sorting.Direction)Sorting.Direction.ASC);
        }
        switch (1.$SwitchMap$net$ripe$rpki$validator3$api$Sorting$By[sorting.getBy().ordinal()]) {
            case 1: {
                comparator = Comparator.comparing(RpkiRepository::getType);
                break;
            }
            case 2: {
                comparator = Comparator.comparing(RpkiRepository::getStatus);
                break;
            }
            case 3: {
                comparator = Comparator.comparing(Base::getUpdatedAt);
                break;
            }
            default: {
                comparator = Comparator.comparing(RpkiRepository::getLocationUri);
            }
        }
        return stream.sorted(sorting.getDirection() == Sorting.Direction.DESC ? comparator : comparator.reversed());
    }

    private Stream<RpkiRepository> applyPaged(Stream<RpkiRepository> stream, Paging paging) {
        if (paging != null) {
            return paging.apply(stream);
        }
        return stream;
    }

    public long countAll(Tx.Read tx, RpkiRepository.Status optionalStatus, Key taId, boolean hideChildrenOfDownloadedParent, SearchTerm searchTerm) {
        return this.applyFiltered(tx, optionalStatus, taId, hideChildrenOfDownloadedParent, searchTerm).count();
    }

    public Stream<RpkiRepository> findAll(Tx.Read tx, RpkiRepository.Status optionalStatus, Key taId) {
        Stream<RpkiRepository> all = this.findAll(tx, taId);
        return optionalStatus == null ? all : all.filter(r -> r.getStatus() == optionalStatus);
    }

    public Stream<RpkiRepository> findAll(Tx.Read tx, Key taId) {
        return this.ixMap.getByIndex(BY_TA, tx, taId).values().stream();
    }

    public Map<RpkiRepository.Status, Long> countByStatus(Tx.Read tx, Key taId, boolean hideChildrenOfDownloadedParent) {
        return this.findAll(tx, null, taId, hideChildrenOfDownloadedParent, null, null, null).collect(Collectors.groupingBy(RpkiRepository::getStatus, Collectors.counting()));
    }

    public Stream<RpkiRepository> findRsyncRepositories(Tx.Read tx) {
        return this.findRepositoriesByPredicate(tx, r -> r.getType() == RpkiRepository.Type.RSYNC || r.getType() == RpkiRepository.Type.RSYNC_PREFETCH);
    }

    public Stream<RpkiRepository> findRrdpRepositories(Tx.Read tx) {
        return this.findRepositoriesByPredicate(tx, r -> r.getType() == RpkiRepository.Type.RRDP);
    }

    private Stream<RpkiRepository> findRepositoriesByPredicate(Tx.Read tx, Predicate<RpkiRepository> p) {
        ArrayList result = new ArrayList();
        this.ixMap.forEach(tx, (k, bb) -> {
            RpkiRepository r = (RpkiRepository)this.ixMap.toValue(bb);
            if (p.test(r)) {
                result.add(r);
            }
        });
        return result.stream();
    }

    public void removeAllForTrustAnchor(Tx.Write tx, TrustAnchor trustAnchor) {
        Ref taRef = Ref.unsafe((String)"trust-anchors", (Key)trustAnchor.key());
        this.ixMap.getByIndex(BY_TA, (Tx.Read)tx, trustAnchor.key()).forEach((pk, rpkiRepository) -> {
            rpkiRepository.removeTrustAnchor(taRef);
            if (rpkiRepository.getTrustAnchors().isEmpty()) {
                if (rpkiRepository.getType() == RpkiRepository.Type.RRDP) {
                    tx.afterCommit(() -> this.validationScheduler.removeRpkiRepository(rpkiRepository));
                }
                this.ixMap.delete(tx, pk);
            } else {
                this.ixMap.put(tx, pk, (Serializable)rpkiRepository);
            }
        });
    }

    public void remove(Tx.Write tx, Key key) {
        this.ixMap.delete(tx, key);
    }

    public Collection<RpkiRepository> findByTrustAnchor(Tx.Read tx, Key key) {
        return this.ixMap.getByIndex(BY_TA, tx, key).values();
    }

    protected IxMap<RpkiRepository> ixMap() {
        return this.ixMap;
    }
}

