/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.storage.data;

import com.google.common.base.Objects;
import java.math.BigInteger;
import java.time.Instant;
import java.util.HashSet;
import java.util.Set;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import net.ripe.rpki.validator3.domain.constraints.ValidLocationURI;
import net.ripe.rpki.validator3.storage.Binary;
import net.ripe.rpki.validator3.storage.data.Base;
import net.ripe.rpki.validator3.storage.data.Ref;
import net.ripe.rpki.validator3.storage.data.RpkiRepository;
import net.ripe.rpki.validator3.storage.data.TrustAnchor;

/*
 * Exception performing whole class analysis ignored.
 */
@Binary
public class RpkiRepository
extends Base<RpkiRepository> {
    public static final String TYPE = "rpki-repository";
    @NotNull
    private String type;
    @NotNull
    private String status;
    private Instant lastDownloadedAt;
    @NotEmpty
    private Set<Ref<TrustAnchor>> trustAnchors = new HashSet();
    @ValidLocationURI
    private String rsyncRepositoryUri;
    @ValidLocationURI
    private String rrdpNotifyUri;
    private String rrdpSessionId;
    private BigInteger rrdpSerial;
    private Ref<RpkiRepository> parentRepository;

    public RpkiRepository() {
    }

    public RpkiRepository(Ref<TrustAnchor> trustAnchor, @NotNull @ValidLocationURI String location, Type type) {
        this.addTrustAnchor(trustAnchor);
        this.status = Status.PENDING.name();
        switch (1.$SwitchMap$net$ripe$rpki$validator3$storage$data$RpkiRepository$Type[type.ordinal()]) {
            case 1: {
                this.type = Type.RRDP.name();
                this.rrdpNotifyUri = location;
                break;
            }
            case 2: 
            case 3: {
                this.type = type.name();
                this.rsyncRepositoryUri = location;
            }
        }
    }

    @ValidLocationURI
    @NotNull
    public String getLocationUri() {
        return (String)Objects.firstNonNull((Object)this.rrdpNotifyUri, (Object)this.rsyncRepositoryUri);
    }

    public void addTrustAnchor(Ref<TrustAnchor> trustAnchor) {
        this.trustAnchors.add(trustAnchor);
    }

    public void removeTrustAnchor(Ref<TrustAnchor> trustAnchor) {
        this.trustAnchors.remove(trustAnchor);
    }

    public boolean isPending() {
        return Status.valueOf((String)this.status) == Status.PENDING;
    }

    public boolean isFailed() {
        return Status.valueOf((String)this.status) == Status.FAILED;
    }

    public boolean isDownloaded() {
        return Status.valueOf((String)this.status) == Status.DOWNLOADED;
    }

    public void setFailed() {
        this.setFailed(Instant.now());
    }

    public void setFailed(Instant lastDownloadedAt) {
        this.status = Status.FAILED.name();
        this.lastDownloadedAt = lastDownloadedAt;
    }

    public void setDownloaded() {
        this.setDownloaded(Instant.now());
    }

    public void setDownloaded(Instant lastDownloadedAt) {
        this.status = Status.DOWNLOADED.name();
        this.lastDownloadedAt = lastDownloadedAt;
    }

    public Type getType() {
        return Type.valueOf((String)this.type);
    }

    public Status getStatus() {
        return Status.valueOf((String)this.status);
    }

    public void setType(Type type) {
        this.type = type.name();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RpkiRepository)) {
            return false;
        }
        RpkiRepository other = (RpkiRepository)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        Instant this$lastDownloadedAt = this.getLastDownloadedAt();
        Instant other$lastDownloadedAt = other.getLastDownloadedAt();
        if (this$lastDownloadedAt == null ? other$lastDownloadedAt != null : !((Object)this$lastDownloadedAt).equals(other$lastDownloadedAt)) {
            return false;
        }
        Set this$trustAnchors = this.getTrustAnchors();
        Set other$trustAnchors = other.getTrustAnchors();
        if (this$trustAnchors == null ? other$trustAnchors != null : !((Object)this$trustAnchors).equals(other$trustAnchors)) {
            return false;
        }
        String this$rsyncRepositoryUri = this.getRsyncRepositoryUri();
        String other$rsyncRepositoryUri = other.getRsyncRepositoryUri();
        if (this$rsyncRepositoryUri == null ? other$rsyncRepositoryUri != null : !this$rsyncRepositoryUri.equals(other$rsyncRepositoryUri)) {
            return false;
        }
        String this$rrdpNotifyUri = this.getRrdpNotifyUri();
        String other$rrdpNotifyUri = other.getRrdpNotifyUri();
        if (this$rrdpNotifyUri == null ? other$rrdpNotifyUri != null : !this$rrdpNotifyUri.equals(other$rrdpNotifyUri)) {
            return false;
        }
        String this$rrdpSessionId = this.getRrdpSessionId();
        String other$rrdpSessionId = other.getRrdpSessionId();
        if (this$rrdpSessionId == null ? other$rrdpSessionId != null : !this$rrdpSessionId.equals(other$rrdpSessionId)) {
            return false;
        }
        BigInteger this$rrdpSerial = this.getRrdpSerial();
        BigInteger other$rrdpSerial = other.getRrdpSerial();
        if (this$rrdpSerial == null ? other$rrdpSerial != null : !((Object)this$rrdpSerial).equals(other$rrdpSerial)) {
            return false;
        }
        Ref this$parentRepository = this.getParentRepository();
        Ref other$parentRepository = other.getParentRepository();
        return !(this$parentRepository == null ? other$parentRepository != null : !this$parentRepository.equals(other$parentRepository));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RpkiRepository;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        Instant $lastDownloadedAt = this.getLastDownloadedAt();
        result = result * 59 + ($lastDownloadedAt == null ? 43 : ((Object)$lastDownloadedAt).hashCode());
        Set $trustAnchors = this.getTrustAnchors();
        result = result * 59 + ($trustAnchors == null ? 43 : ((Object)$trustAnchors).hashCode());
        String $rsyncRepositoryUri = this.getRsyncRepositoryUri();
        result = result * 59 + ($rsyncRepositoryUri == null ? 43 : $rsyncRepositoryUri.hashCode());
        String $rrdpNotifyUri = this.getRrdpNotifyUri();
        result = result * 59 + ($rrdpNotifyUri == null ? 43 : $rrdpNotifyUri.hashCode());
        String $rrdpSessionId = this.getRrdpSessionId();
        result = result * 59 + ($rrdpSessionId == null ? 43 : $rrdpSessionId.hashCode());
        BigInteger $rrdpSerial = this.getRrdpSerial();
        result = result * 59 + ($rrdpSerial == null ? 43 : ((Object)$rrdpSerial).hashCode());
        Ref $parentRepository = this.getParentRepository();
        result = result * 59 + ($parentRepository == null ? 43 : $parentRepository.hashCode());
        return result;
    }

    public Instant getLastDownloadedAt() {
        return this.lastDownloadedAt;
    }

    public Set<Ref<TrustAnchor>> getTrustAnchors() {
        return this.trustAnchors;
    }

    public String getRsyncRepositoryUri() {
        return this.rsyncRepositoryUri;
    }

    public String getRrdpNotifyUri() {
        return this.rrdpNotifyUri;
    }

    public String getRrdpSessionId() {
        return this.rrdpSessionId;
    }

    public BigInteger getRrdpSerial() {
        return this.rrdpSerial;
    }

    public Ref<RpkiRepository> getParentRepository() {
        return this.parentRepository;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setLastDownloadedAt(Instant lastDownloadedAt) {
        this.lastDownloadedAt = lastDownloadedAt;
    }

    public void setTrustAnchors(Set<Ref<TrustAnchor>> trustAnchors) {
        this.trustAnchors = trustAnchors;
    }

    public void setRsyncRepositoryUri(String rsyncRepositoryUri) {
        this.rsyncRepositoryUri = rsyncRepositoryUri;
    }

    public void setRrdpNotifyUri(String rrdpNotifyUri) {
        this.rrdpNotifyUri = rrdpNotifyUri;
    }

    public void setRrdpSessionId(String rrdpSessionId) {
        this.rrdpSessionId = rrdpSessionId;
    }

    public void setRrdpSerial(BigInteger rrdpSerial) {
        this.rrdpSerial = rrdpSerial;
    }

    public void setParentRepository(Ref<RpkiRepository> parentRepository) {
        this.parentRepository = parentRepository;
    }

    public String toString() {
        return "RpkiRepository(type=" + this.getType() + ", status=" + this.getStatus() + ", lastDownloadedAt=" + this.getLastDownloadedAt() + ", trustAnchors=" + this.getTrustAnchors() + ", rsyncRepositoryUri=" + this.getRsyncRepositoryUri() + ", rrdpNotifyUri=" + this.getRrdpNotifyUri() + ", rrdpSessionId=" + this.getRrdpSessionId() + ", rrdpSerial=" + this.getRrdpSerial() + ", parentRepository=" + this.getParentRepository() + ")";
    }
}

