/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.domain;

import fj.data.Either;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.util.CertificateRepositoryObjectFactory;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.validator3.storage.data.RpkiObject;
import org.apache.commons.lang3.tuple.Pair;

public class RpkiObjectUtils {
    public static Either<ValidationResult, Pair<String, RpkiObject>> createRpkiObject(String uri, byte[] content) {
        ValidationResult validationResult = ValidationResult.withLocation((String)uri);
        CertificateRepositoryObject repositoryObject = CertificateRepositoryObjectFactory.createCertificateRepositoryObject((byte[])content, (ValidationResult)validationResult);
        if (validationResult.hasFailures()) {
            return Either.left((Object)validationResult);
        }
        try {
            return Either.right((Object)Pair.of((Object)uri, (Object)new RpkiObject(repositoryObject)));
        }
        catch (Exception e) {
            validationResult.rejectIfFalse(false, "objects.general.parsing", new String[0]);
            return Either.left((Object)validationResult);
        }
    }
}

